#include <stdlib.h>
#include <stdio.h>

#include "tree.h"

#define max(a, b) ((a) >= (b) ? (a) : (b))

/* OUTPUT: -> */
tree tree_alloc(){
    return (tree)malloc(sizeof(node));
}

tree tree_create_leaf(int c){
    tree T = tree_alloc();

    T->left = NULL;
    T->right = NULL;
    T->c = c;
    return T;
}

void tree_free(tree T){
    if(T != NULL){
	tree_free(T->left);
	tree_free(T->right);
	free(T);
    }
}

tree tree_join(int c, tree L, tree R){
    tree T = tree_alloc();

    T->left = L;
    T->right = R;
    T->c = c;
    return T;
}

void tree_prefix_print(tree T){
    if(T != NULL){
	printf(" %d", T->c);
	tree_prefix_print(T->left);
	tree_prefix_print(T->right);
    }
}

void tree_infix_print(tree T){
    if(T != NULL){
	tree_infix_print(T->left);
	printf(" %d", T->c);
	tree_infix_print(T->right);
    }
}

void tree_postfix_print(tree T){
    if(T != NULL){
	tree_postfix_print(T->left);
	tree_postfix_print(T->right);
	printf(" %d", T->c);
    }
}

/* OUTPUT: height of the tree */
int tree_height(tree T){
    if(T == NULL)
	return 0;
    else
	return 1 + max(tree_height(T->left), tree_height(T->right));
}

/* OUTPUT: if c is in T, return the first part of T containing c */
tree tree_is_in(int c, tree T){
    return NULL;
}
