#include <stdlib.h>
#include <stdio.h>

#include "list.h"

/* OUTPUT: -> */
list list_alloc(){
    return (list)malloc(sizeof(__list));
}

/* OUTPUT: -> c -> NULL */
list list_create(int c){
    list tmp = list_alloc();

    tmp->c = c;
    tmp->next = NULL;
    return tmp;
}

void list_print(list L){
    for(; L != NULL; L = L->next)
	printf(" -> %d", L->c);
}

/* returns c -> L */
list list_add_first(int c, list L){
    list tmp = list_alloc();

    tmp->c = c;
    tmp->next = L;
    return tmp;
}

void list_free(list L){
    if(L != NULL){
	list_free(L->next);
	free(L);
    }
}

/* [c, L] outputs L */
list list_remove_first(int *ptr_c, list L){
    list tmp;
    
    if(L == NULL){
	*ptr_c = -1; /* why not? */
	return L;
    }
    *ptr_c = L->c;
    tmp = L->next;
    free(L);
    return tmp;
}

/* OUTPUT: length of the list */
int list_length(list L){
    if(L == NULL)
	return 0;
    else
	return 1 + list_length(L->next);
}

/* OUTPUT: if c is in L, return the first part of L containing c */
list list_is_in(int c, list L){
    if(L == NULL || L->c == c)
	return L;
    return list_is_in(c, L->next);
}
