package Jcg.viewer.processing3d;

import java.io.*;
import java.util.Collection;

import processing.core.*;

import Jcg.geometry.Triangle_3;


/**
 * A simple 3d viewer for visualizing surface meshes (based on Processing)
 * 
 * @author Luca Castelli Aleardi (INF555, 2012)
 *
 */
public class MeshViewerProcessing extends PApplet {

	public DrawPolyhedronProcessing drawingMethod=null; // drawing method for rendering the 3d surface mesh
	public int renderType=1; // choice of type of rendering
	public int renderModes=3; // number of rendering modes
	public float zoomFactor=1f;
	
	public static String filename=null; // input mesh
	
	public void setup() {
		System.out.println("Setting Mesh Viewer (based on Processing 1.51)");
		size(800,600,P3D);
		ArcBall arcball = new ArcBall(this);
	}
	
	/**
	 * Set the input mesh (stored in file, OFF format)
	 * 
	 * @param name input file storing the mesh
	 */
	public static void setInputFile(String name) {
		File file = new File(name);
		if(file.exists()==false) { 
			throw new Error("Error: input file not found "+name+" not found");
		}
		filename=name;
	}

	public void draw() {
		this.setLights();

		if(this.drawingMethod!=null)
			this.drawingMethod.draw(renderType);
		else {
			System.out.println("This class does not render any 3D scene");
			System.out.println("You should run a class extending the class MeshViewerProcessing");
			System.exit(0);
		}
	}

		public void setLights() {
			background(255);
			directionalLight(120, 120, 120, 0, 0, -1);
			directionalLight(120, 120, 120, 0, 0, 1);
			directionalLight(120, 120, 120, 1, 0, 0);
			directionalLight(120, 120, 120, 0, 1, 0);
			ambientLight(40, 40, 40);
			//pointLight(126, 126, 126, 1000, 1000, 1000);

			float factor=2f;
			translate(width/factor,height/factor,-1*height/(factor));
			scale(this.zoomFactor);
			this.strokeWeight(1);
			stroke(150,150,150);
		}

		public void keyPressed(){
			  switch(key) {
			    case('r'):this.renderType=(this.renderType+1)%this.renderModes; break;
			    case('+'):this.zoomIn(); break;
			    case('-'):this.zoomOut(); break;
			  }
		}
		
		public void zoomIn(){
			this.zoomFactor*=1.1f;
		}
		
		public void zoomOut(){
			this.zoomFactor*=0.92f;
		}
		

		/**
		 * Return a real value after truncation (with a given numeric precision)
		 */
		public static double round(double x, int precision) {
			return ((int)(x*precision)/(double)precision);
		}

		/**
		 * For running the PApplet as Java application
		 */
		public static void main(String args[]) {			
			PApplet.main(new String[] { "Jcg.viewer.processing3d.MeshViewerProcessing" });
		}

}
