package Jcg.viewer;

import Jcg.geometry.Point_3;

/**
 * Abstract class defining methods for drawing a graph in 3D
 * 
 * @author Luca Castelli Aleardi (Ecole Polytechnique, INF555 and INF562), 2012
 *
 */
public abstract class DrawSkeleton {
	
	// define rendering modes
	public static final int VERTICES_AND_EDGES=0;
	public static final int NO_VERTICES_NO_EDGES=1;
	public static final int ONLY_EDGES=2;

	/**
	 * Draw a segment between two points
	 */	
	public abstract void drawSegment(Point_3 p, Point_3 q);
	
	/**
	 * Draw a vertex
	 */	
	public abstract void drawVertex(Point_3 p);
	
	/**
	 * Draw the entire graph (or mesh)
	 * 
	 * @param      type    indicates the rendering mode
	 */
	public abstract void draw(int type);
	
	/**
	 * Draw the X, Y and Z axis
	 */
	public void drawAxis() {
		double s=1;
		Point_3 p000=new Point_3(0., 0., 0.);
		Point_3 p100=new Point_3(s, 0., 0.);
		Point_3 p010=new Point_3(0.,s, 0.);
		Point_3 p011=new Point_3(0., 0., s);
		
		drawSegment(p000, p100);
		drawSegment(p000, p010);
		drawSegment(p000, p011);
	}
	
	/**
	 * Draw the X, Y and Z axis
	 */
	public void drawBoundingBox(Point_3[] box) {
	}

	/**
	 * Return the value after truncation
	 */
	public static double round(double x, int precision) {
		return ((int)(x*precision)/(double)precision);
	}
	
	/**
	 * Compute the scale factor (depending on the max distance of the point set)
	 */
	public Point_3[] computeBoundingBox() {
		throw new Error("To be completed");
	}

}
