package Jcg.viewer;

import Jcg.geometry.Point_3;

/**
 * Abstract class defining methods for rendering a surface mesh in 3D
 * 
 * @author Luca Castelli Aleardi (Ecole Polytechnique, INF555 and INF562), 2012
 *
 */
public abstract class DrawMesh extends DrawSkeleton {

	/**
	 * Draw a triangle
	 */	
	public abstract void drawTriangle(Point_3 p, Point_3 q, Point_3 r);

	/**
	 * Draw a (triangle or polygonal) face
	 */	
	public abstract void drawFace(Point_3[] f);

}
