package Jcg.viewer;

import Jcg.geometry.Point_2;

/**
 * Abstract class defining methods for drawing points and segments in a 2D frame
 * 
 * @author Luca Castelli Aleardi (Ecole Polytechnique, INF555 and INF562), 2012
 *
 */
public abstract class Draw2D {
	
	// define rendering modes
	public static final int VERTICES_AND_EDGES=0;
	public static final int NO_VERTICES_NO_EDGES=1;
	public static final int ONLY_EDGES=2;

	/**
	 * Draw a segment between two points
	 */	
	public abstract void drawSegment(Point_2 p, Point_2 q);
	
	/**
	 * Draw a vertex
	 */	
	public abstract void drawPoint(Point_2 p);
	
	/**
	 * Draw the entire graph (or mesh)
	 * 
	 * @param      type    indicates the rendering mode
	 */
	public abstract void draw(int type);
	
	/**
	 * Draw the cartesian axis X and Y
	 */
	public void drawAxis() {
		double s=1;
		Point_2 p00=new Point_2(0., 0.);
		Point_2 p10=new Point_2(s, 0.);
		Point_2 p01=new Point_2(0.,s);
		
		drawSegment(p00, p10);
		drawSegment(p00, p01);
	}
	
	/**
	 * Resize the frame according to the window coordinates
	 * Input points are the left bottom and right top points of the window
	 */
	public abstract void resize(Point_2 leftBottom, Point_2 rightTop);
	
	/**
	 * Draw a bounding box (a rectangle)
	 */
	public void drawBoundingBox(Point_2[] box) {
		if(box==null || box.length<2)
			return;
		Point_2 p00=new Point_2(box[0].getX(), box[0].getY());
		Point_2 p10=new Point_2(box[1].getX(), box[0].getY());
		Point_2 p01=new Point_2(box[0].getX(), box[1].getY());
		Point_2 p11=new Point_2(box[1].getX(), box[1].getY());
		
		this.drawSegment(p00, p10);
		this.drawSegment(p00, p01);
		this.drawSegment(p10, p11);
		this.drawSegment(p01, p11);
	}

	/**
	 * Return the value after truncation
	 */
	public static double round(double x, int precision) {
		return ((int)(x*precision)/(double)precision);
	}
	
	/**
	 * Compute the scale factor (depending on the max distance of the point set)
	 */
	public Point_2[] computeBoundingBox() {
		throw new Error("To be completed");
	}

}
