package Jcg.util;

public class PrintUtil {
	public static final String ANSI_RESET = "\u001B[0m";
	public static final String ANSI_RED = "\033[1;31m";
	public static final String ANSI_GREEN = "\033[1;32m";
	public static final String ANSI_PURPLE = "\033[1;95m";
	public static final String ANSI_BLUE = "\033[1;34m";
	public static final String ANSI_MAGENTA = "\u001B[35;1m";
	public static final String ANSI_CYAN = "\u001B[36;1m";

	/**
	 * Print an array of integers (separated by spaces)
	 */    
	public static void print(int[] t) {
		int n=t.length; // number of vertices

		for(int i=0;i<n;i++) { // iterate over all vertices in the triangulation
			System.out.print(t[i]+" ");
		}
		System.out.println();
	}

	/**
	 * Return an approximation of a real (double) number, with a given precision
	 * 
	 * @param x		the input real number
	 * @param prec	numeric precision
	 * @return		an approximation of x
	 */
	public static double approx(double x, int prec) {
		double p=(int)Math.pow(10, prec);
		return ((int)(x*p))/p;
	}

}
