package Jcg.util;

/**
 * Node of a doubly linked list, for storing generic type elements. <br>
 * <br>
 * <b>Remark</b>: the list can be circular (if needed)
 * 
 * @author Luca Castelli Aleardi (Ecole Polytechnique, 2013-2024)
 */
public class DListNode<X> {
		/** (generic) data stored in a node of the list */
		public X element;
		/** a reference to the next node in the list */
		DListNode<X> next;
		/** a reference to the previous node in the list */
		DListNode<X> previous;

		public DListNode(X element, DListNode<X> next, DListNode<X> previous) {
			this.element = element;
			this.next = next;
			this.previous = previous;
		}

		public X getElement() {
			return this.element;
		}

		public DListNode<X> getNext() {
			return this.next;
		}

		public DListNode<X> getPrev() {
			return this.previous;
		}

		public void setElement(X element) {
			this.element=element;
		}

		public void setNext(DListNode<X> next) {
			this.next=next;
		}

		public void setPrev(DListNode<X> prev) {
			this.previous=prev;
		}

}
