package Jcg.util;


/** 
 * An implementation of a bit-vector (using memory words on 32 bits)
 * @author Luca Castelli Aleardi (older version by Yonik)
 */
public class BitSet32 implements BitSetInterface {

	 public int[] bits;		// array storing the data
	 public int numBits;   	// number of bits
	 private int wordsLength; 	// number of memory words
	 private int wordSize=32; 	// size (in bits) of a memory word

	  /** 
	   * Constructs a BitSet large enough to hold numBits.
	   * @param numBits  number of bits
	   */
	  public BitSet32(int bitsSize) {
		  this.numBits=bitsSize;
		  this.wordsLength=(this.numBits/wordSize)+1;
		  bits = new int[this.wordsLength];
	  }

	  /** 
	   * Constructs a BitSet, from an array already initialized
	   * @param numBits  number of bits
	   * @param bits  an array of integers storing the BitSet
	   */
	  public BitSet32(int[] bits, int bitsSize) {
		  this.numBits=bitsSize;
		  this.bits=bits;
		  this.wordsLength=bits.length;
	  }

	  /**
	   * Returns the size of the bitset (number of words)
	   */
	  public int size() {
		  return bits.length << 5;
	  }

	  /**
	   * Returns the size in term of bits
	   */
	  public int bitSize() {
		  return this.numBits;
	  }

	  public boolean get(int index) {
		    int i = index >> 5;               // div 32
		    // signed shift will keep a negative index and force an
		    // array-index-out-of-bounds-exception, removing the need for an explicit check.
		    
		    //int bitIndex = index & 0x3f;      	// mod 64
		    int bitIndex=index%wordSize;			// mod 32 
		    int bitmask = 1 << bitIndex;
		    return (bits[i] & bitmask) != 0;
	  }
	 
	  /** 
	   * Returns 1 if the bit is set, 0 if not.
	   * The index should be less than the OpenBitSet size
	   * LCA: a' controler
	   */
	  public int getBit(int index) {
		  int i = index >> 5; // div 32
		  // int bit = index & 0x3f; // mod 64
		  int bit=index%wordSize; // 32
		  return ((int) (bits[i] >>> bit)) & 0x01;
	  }
	  
	  public void set(int index) {
		    int wordNum = index >> 5;      // div 32
		    //int bit = index & 0x3f;     // mod 64
		    int bitIndex=index%wordSize;	// LCA mod 32
		    int bitmask = 1 << bitIndex;
		    bits[wordNum] |= bitmask;
	  }
	  
	  /** 
	   * Clears a bit.
	   * The index should be less than the OpenBitSet size.
	   */
	  public void clear(int index) {
		  int wordNum = index >> 5;			// div 32
		    // int bit = index & 0x03f;		// mod 64
		    int bit=index%wordSize;			// mod 32
		    int bitmask = 1 << bit;
		    bits[wordNum] &= ~bitmask;
	  }
	  
	  /** 
	   * Return an array of bytes storing the whole bit set <p>
	   * 
	   * Remark: the array of bytes is of size 4*W, where W is the number of words storing the bit set
	   * which is: size(bit set)/32
	   * 
	   * @return an array of bytes, storing the values in the bit set
	   */
	  public byte[] toByteArray() {
		  byte[] result=new byte[this.wordsLength];
		  
		  throw new Error("To be completed");
	  }
	  
	  public String toString() {
		  String result="";
		  for(int i=0;i<this.bitSize();i++) {
			  result=result+this.getBit(i);
		  }
		  return result;
	  }

}
