package Jcg.triangulations2D;

import Jcg.geometry.*;

/**
 * 
 * The class represents a vertex of a 2D triangulation. Each vertex stores a pointer to one of 
 * its incident faces. 
 *
 * @author Luca Castelli Aleardi and Steve Oudot (Ecole Polytechnique, 2012-24)
 *
 */
public class TriangulationDSVertex_2<X extends Point_> implements Comparable<TriangulationDSVertex_2<X>> {
	
	/** Face incident to the vertex */
	TriangulationDSFace_2<X> face=null;
	
	/** Geometric coordinates of the vertex */
	public X point=null;
	public int tag;
	
	/** Index of a vertex: useful for storing additional data associated with vertices */
	public int index; // useful for input/output operations and format conversions

	/**
	 * Creates an empty vertex, with no associated geometric point.
	 *
	 */
	public TriangulationDSVertex_2() {}

	/**
	 * creates a vertex with an associated geometric point.
	 * @param point  geometric coordinates (2D) of the vertex
	 */
	public TriangulationDSVertex_2(X point) { this.point=point; }

	/**
	 * creates a vertex with an associated geometric point and an associated cell.
	 */
	public TriangulationDSVertex_2(TriangulationDSFace_2<X> c, X point) {
	    	this.face=c;
	    	this.point=point; 
	    }

	/**
	 * sets the face associated with the vertex.
	 */
	public void setFace(TriangulationDSFace_2<X> c) { this.face=c; }

	/**
	 * sets the geometric point associated with the vertex.
	 */
	public void setPoint(X point) { this.point=point; }  
	    
	/**
	 * returns the geometric point associated with the vertex.
	 */
	public X getPoint() { return this.point; } 

	/**
	 * returns the cell associated with the vertex.
	 */
	public TriangulationDSFace_2<X> getFace() { return this.face; } 

	/**
	 * returns an half-edge handle 'h' incident to the vertex 'v' (the target of 'h' is 'v')
	 */
	public HalfedgeHandle<X> getHalfedge() {
		TriangulationDSFace_2<X> f=this.getFace(); // face incident to the vertex
		int i=f.index(this); // index of the current vertex in the face 'f'
		HalfedgeHandle<X> h=new HalfedgeHandle<X>(f, (i+1)%3);
		
		if(h.getVertex()!=this)
			throw new Error("Error: the current vertex is not the targer of the resulting half-edge");
		
		return h;
	}
	    
	/**
	 * returns a string listing the coordinates of the geometric point associated with the vertex.
	 */
	public String toString(){
	        return "vertex "+point.toString();
	    }

	public int compareTo(TriangulationDSVertex_2<X> v) {
		return getPoint().compareTo(v.getPoint());
	}	

}
