package Jcg.test;

import Jcg.geometry.Point_2;
import Jcg.geometry.Point_3;
import Jcg.mesh.Triangulations_IO;
import Jcg.triangulations2D.TriangulationDSFace_2;
import Jcg.triangulations2D.TriangulationDS_2;

/**
 * This class provides methods for testing the Triangle based Data Structure for triangulation
 */    
public class Test_TriangulationDS_2 {

    /**
     * testing function for 2D meshes.
     */    
    public static void test2D(){
    	System.out.println("Testing TriangulationDS_2");
    	Point_2 p0=new Point_2(0.,0.);
    	Point_2 p1=new Point_2(1.,0.);
    	Point_2 p2=new Point_2(0.,1.);
    	
    	TriangulationDS_2<Point_2> triangulation2D=new TriangulationDS_2<Point_2>();
    	TriangulationDSFace_2<Point_2> c=triangulation2D.makeTriangle(p0, p1, p2);
    	triangulation2D.isValid();

    	triangulation2D.insertBarycenter(triangulation2D.faces.get(0));
    	triangulation2D.insertBarycenter(triangulation2D.faces.get(0));
    	triangulation2D.insertBarycenter(triangulation2D.faces.get(1));
    	triangulation2D.insertBarycenter(triangulation2D.faces.get(2));
    	triangulation2D.insertBarycenter(triangulation2D.faces.get(0));
    	triangulation2D.insertBarycenter(triangulation2D.faces.get(1));
    	triangulation2D.insertBarycenter(triangulation2D.faces.get(2));
    	triangulation2D.isValid();   	
     }

    /**
     * testing function for 3D surface triangle meshes.
     */    
    public static void test3D(String filename){
    	TriangulationDS_2<Point_3> surfaceMesh=Triangulations_IO.getTriangleMeshFromFile(filename);
    	surfaceMesh.isValid();
    }

    /**
     * testing function for plane triangle meshes.
     */    
    public static void testPlaneTriangulation(String filename){
    	TriangulationDS_2<Point_2> triangulation=Triangulations_IO.getPlaneTriangulationFromFile(filename);
    	triangulation.isValid();
    }

    /**
     * main testing function.
     */    
    public static void main(String[] args){
		System.out.println("Testing TriangulationDS_2 for 3D surface meshes");
    	if (args.length == 0) {
    		System.out.println("Warning: mssing input argument\nI wait for a triangle mesh stored in OFF format");
    		return;
    	}
    	
    	String filename=args[0];
    	test3D(filename);
    	System.out.println("Test done");
    }

}
