package Jcg.test;
import Jcg.meshgeneration.RandomSamplingTriangulations;
import Jcg.polyhedron.Halfedge;

/**
 * A simple program for testing the random generation of planar triangulations
 * It generates uniform planar random triangulations, 
 * according to the generator by Poulalhon/Schaeffer (Icalp 2003)
 * 
 * Warning: It works fine for triangulations having up to 2M vertices (with Java 7, 64 bits, 5GB Ram)
 * 
 * @author Luca Castelli Aleardi (Ecole Polytechnique, 2015)
 *
 */
public class TestRandomGeneration {

	public static void main(String[] args) {
		if(args.length<2) {
			System.out.println("Parameter missing (2 parameters required)");
			System.out.println("first parameter: \tN\t\t to generate a random triangulation of size N+2");
			System.out.println("second parameter: \toutput.off\t storing the triangulation");
			return;
		}
	    else {
	        int n = Integer.valueOf(args[0]).intValue();
	        RandomSamplingTriangulations sampler=new RandomSamplingTriangulations(false);
	        sampler.generateTriangulation(n);
	        sampler.poly.isValid(false);
	        
	        Halfedge h=null; // boundary edge
	        for(Halfedge e: sampler.poly.halfedges) // find a boundary edge
	        	if(e.face==null)
	        		h=e;
	        sampler.poly.fillHole(h); // add the outer face
	        sampler.poly.isValid(false); // check validity (the mesh must be without boundary)
	        
	        System.out.print("Generating random planar triangulation of size "+n+"...");
	        System.out.println("done");
	        Jcg.mesh.IO.writePolyedronToOFF(sampler.poly, args[1]);
        }
	}

}
