package Jcg.test;

import Jcg.geometry.*;
import Jcg.mesh.*;
import Jcg.polyhedron.*;

/**
 * A class for testing the Half-edge data structure representing polyhedral surfaces.
 * 3D rendering is performed using a Mesh Viewer based on Processing (version 1.51) 
 *
 * @author Luca Castelli Aleardi (INF562, 2019)
 *
 */
public class TestPolyhedron {
	
	/**
	 * Testing a plane triangulation (loaded from an OFF file)
	 */    
	public static void test2D(String filename) {
    	Polyhedron_3<Point_2> planarGraph=MeshLoader.getPlanarMesh(filename);

    	//System.out.println(planarGraph.verticesToString());   	
    	//System.out.println(planarGraph.facesToString());
    	planarGraph.isValid(false); // check combinatorial validity
    	System.out.println("Test done");    	
    }

	/**
	 * Load a mesh from an OFF file, shows statistics and check validity
	 */    
	public static void meshStatistics(String filename) {
		// build the mesh representation
		Polyhedron_3<Point_3> polyhedron3D=MeshLoader.getSurfaceMesh(filename);
		polyhedron3D.isValid(false); // check combinatorial validity
	}

	/**
	 * Load a mesh from an OFF file, shows statistics and check validity
	 */    
	public static void meshConversion(String filename) {
		// build the mesh representation
		Polyhedron_3<Point_3> polyhedron3D=MeshLoader.getSurfaceMesh(filename);
		//polyhedron3D.isValid(false); // check combinatorial validity
		IO.writePolyedronToEDGES(polyhedron3D, "output", ",");
	}

    public static void main (String[] args) {
		System.out.println("Java version: "+System.getProperty("java.version"));
		System.out.println("Java home: "+System.getProperty("java.home"));
    	
		System.out.println("Testing Half-edge DS for polyhedral surfaces");
    	if (args.length == 0) {
    		System.out.println("I wait for a mesh stored in OFF or OBJ format");
    		System.out.println("Usage : java TestPolyhedron filename");
    		return;
    	}

    	String filename=args[0];
    	meshStatistics(filename);
    }

}
