package Jcg.test;

import Jcg.geometry.*;
import Jcg.mesh.Triangulations_IO;
import Jcg.triangulations2D.Delaunay_2;

/**
 * A class for testing the construction of a 2D Delaunay triangulation.
 * @author Luca Castelli Aleardi
 */
public class TestDelaunay2D {

	public static void main (String[] args) {
		System.out.println("Testing the construction of a 2D Delaunay triangulation");
		double scale=1.; // scale factor (radius of the circle)
		int n=0; // number of vertices
		if(args.length>0) {
			n=Integer.parseInt(args[0]);
		}
		else {
			System.out.println("Warning: one parameter required: number of points");
			System.exit(0);
		}

		/* create the data structure (Delaunay triangulation with one triangle bounding the outer face) */
		Delaunay_2 delaunay = new Delaunay_2(new Point_2(-2.*scale, -1.*scale), new Point_2(2.*scale, -1.*scale), new Point_2(0.*scale, 2.*scale));
		//Delaunay_2 delaunay=new Delaunay_2();	

		/* create and insert vertices, updating Delaunay incrementally */
		System.out.print("Inserting "+n+" points (chosen at random)...");
		int cont=0;
		for (int i=0; i<n;) {
			Point_2 p = new Point_2 (1*scale-2*scale*Math.random(), 1*scale-2*scale*Math.random());
			// test whether the random point lies in the circle
			if (p.squareDistance(new Point_2(0.,0.)).doubleValue() <= scale*scale) {
				delaunay.insert( p );
				i++;
			}
			cont++;
		}

		System.out.println("done");
		int nVertices=delaunay.tri.sizeOfVertices();
		System.out.println("Delaunay triangulation computed: "+nVertices+" vertices");
		Triangulations_IO.writeTriangleMeshToOFF(delaunay.tri, "Delaunay_"+(n+3)+".off");
		
		System.out.println("Test done");
    }
}
