package Jcg.test;
import Jcg.geometry.Point_3;
import Jcg.mesh.IO;
import Jcg.mesh.MeshLoader;
import Jcg.meshgeneration.RandomSamplingTriangulations;
import Jcg.meshgeneration.RegularGridGeneration;
import Jcg.meshgeneration.SphereGeneration;
import Jcg.meshgeneration.StackedGeneration;
import Jcg.polyhedron.Halfedge;
import Jcg.polyhedron.Polyhedron_3;

public class GenerateMesh {

    public static void main (String[] args) {
    	System.out.println("Mesh generation (Luca Castelli Aleardi, 2020)");
    	System.out.println("This program allows to generate a few classes of synthetic and random meshes.");
    	System.out.println("The resulting mesh is provided with a geometric 3D embedding and stored in OFF format.\n");
    	if (args.length<2 || args[0].equals("-help")) {
    		printHelp();
    		return;
    	}
    	
    	if(args[0].equals("-sphere")) {
    		int iterations=Integer.parseInt(args[1]);
    		SphereGeneration sphere=new SphereGeneration();
    		sphere.run(iterations);
    		Jcg.mesh.IO.writePolyedronToOFF(sphere.polyhedron3D, "sphere.off");
    	}
    	else if(args[0].equals("-stacked")) {
    		int iterations=Integer.parseInt(args[1]);
    		StackedGeneration stacked=new StackedGeneration();
    		stacked.subdivideAllFaces(iterations);
    		Jcg.mesh.IO.writePolyedronToOFF(stacked.polyhedron3D, "stacked.off");
    	}
    	else if(args[0].equals("-trigrid")) {
        	int n=Integer.parseInt(args[1]);
        	
        	RegularGridGeneration.writeTriangularGrid(n, n, "trigrid"+n+".off");
    	}
    	else if(args[0].equals("-cylinder")) {
        	int n=Integer.parseInt(args[1]);
        	int m=Integer.parseInt(args[2]);
        	
        	RegularGridGeneration.writeRegularCylinder(n, m, "cylinder"+n+"x"+m+".off");
    	}
    	else if(args[0].equals("-globe")) {
        	int n=Integer.parseInt(args[1]);
        	
        	n=(int)Math.ceil(Math.sqrt(n));
        	RegularGridGeneration.writeRegularGlobe(n, "globe"+n+".off");
        	System.out.println("Output file: size "+n);
    	}
    	else if(args[0].equals("-random")) {
    		int n=Integer.parseInt(args[1])-2;
	        RandomSamplingTriangulations sampler=new RandomSamplingTriangulations(false);
	        sampler.generateTriangulation(n);
	        sampler.poly.isValid(false);
	        
	        Halfedge h=null; // boundary edge
	        for(Halfedge e: sampler.poly.halfedges) // find a boundary edge
	        	if(e.face==null)
	        		h=e;
	        sampler.poly.fillHole(h); // add the outer face
	        sampler.poly.isValid(false); // check validity (the mesh must be without boundary)
	        
	        System.out.print("Generating random planar triangulation of size "+n+"...");
	        System.out.println("done");
	        Jcg.mesh.IO.writePolyedronToOFF(sampler.poly, "random"+args[1]+".off");
    	}
    	else if(args[0].equals("-ro")) {
        	String filename=args[1];
			Polyhedron_3<Point_3> mesh=MeshLoader.getSurfaceMesh(filename); // store the input mesh and graph
			mesh.resetMeshIndices();
        	
			String output=filename.replace(".off", "");
			output=output+"_reversed.off";
        	IO.writeReversedPolyedronToOFF(mesh, output);
    	}
        
    }
    
    public static void printHelp() {
		System.out.println("Warning: at least two input parameters required");
		System.out.println("Input OPTIONS include:");
		System.out.println("\t -sphere [iterations]");
		System.out.println("\t -globe [size]");
		System.out.println("\t -grid [width] [height]");
		System.out.println("\t -trigrid [size]");
		System.out.println("\t -cylinder [width] [height]");
		System.out.println("\t -random [size]");
		System.out.println("\t -delaunay [size]");
		System.out.println("\t -ro [inputmesh.off]	(reverse face orientation)");
		System.out.println("\nUsage example 1: java GenerateMesh -sphere 2");
		System.out.println("Usage example 2: java GenerateMesh -globe 100 100");
		System.out.println("Usage example 3: java GenerateMesh -random 1000");
		System.out.println("Usage example 4: java GenerateMesh -ro sphere.off");   	
    }

}
