package Jcg.polyhedron;

import java.util.LinkedList;
import java.util.List;

import Jcg.geometry.*;


public class Vertex<X extends Point_>{

Halfedge<X> halfedge=null;
X point=null;
public int tag;
public int index;

    public Vertex(X point) { this.point=point; }
    public Vertex() {}

    public void setEdge(Halfedge<X> halfedge) { this.halfedge=halfedge; }
    public void setPoint(X point) { this.point=point; }  
    
    public X getPoint() { return this.point; } 
    public Halfedge<X> getHalfedge() { return this.halfedge; } 
    
    public String toString(){
        return "v"+this.index+" "+point.toString();
    }
    
    /**
     * Return the list of the (outgoing) halfedges incident to the vertex <p>
     * 
     * Remark: Half-edges are listed in cw order
     */
    public List<Halfedge<X>> getOutgoingHalfedges() {
    	LinkedList<Halfedge<X>> result=new LinkedList<Halfedge<X>>();
    	Halfedge<X> e=this.getHalfedge(); // halfedge incident to v (having v as destination)
    	result.add(e.getOpposite());
    	
    	Halfedge<X> pEdge=e.getNext().getOpposite();
    	while(pEdge!=e) {
    		result.add(pEdge.getOpposite()); // get the opposite half-edge (outgoing from v)
    		pEdge=pEdge.getNext().getOpposite(); // get next hafledge arounf v in cw order
    	}
    	return result;
    }

}


