package Jcg.polyhedron;

import java.util.Arrays;

public class SeparatingTriangle {
	public Halfedge[] edges;
	
	public SeparatingTriangle(Halfedge[] edges) {
		this.edges=edges;
	}
	
	@Override
	public boolean equals(Object o) {
		SeparatingTriangle t=(SeparatingTriangle)o;
		
		int[] sorted1=getSortedVertices(this.edges);
		int[] sorted2=getSortedVertices(t.edges);
		//System.out.println("\t t1: "+sorted1[0]+", "+sorted1[1]+", "+sorted1[2]);
		//System.out.println("\t t2: "+sorted2[0]+", "+sorted2[1]+", "+sorted2[2]);
		
		boolean res=true;
		if(sorted1[0]!=sorted2[0])
			res=false;
		if(sorted1[1]!=sorted2[1])
			res=false;
		if(sorted1[2]!=sorted2[2])
			res=false;
		
		return res;
	}
	
	@Override
	public int hashCode() {
		return edges[0].getVertex().index*edges[1].getVertex().index*edges[2].getVertex().index;
	}
	
	private static int[] getSortedVertices(Halfedge[] e) {
		int[] sorted=new int[3];
		
		// min index
		sorted[0]=e[0].getVertex().index;
		sorted[1]=e[1].getVertex().index;
		sorted[2]=e[2].getVertex().index;
		
		Arrays.sort(sorted);
		
		return sorted;
	}

}
