package Jcg.polyhedron;

import Jcg.geometry.*;


/**
 * Class for representing half-edges (half-edge representation of a surface mesh)
 *
 * @author Code by Luca Castelli Aleardi (INF555/562, 2012-2020)

 */
public class Halfedge<X extends Point_>{

	/** a reference to next half-edge (in ccw direction) in the same incident face */
	public Halfedge<X> next;
	
	/** a reference to opposite half-edge, lying in the neighboring face */
	public Halfedge<X> opposite;
	
	/** a reference to target of this half-edge */
	public Vertex<X> vertex;

	/** a reference to previous half-edge (in ccw direction) in the same incident face. <br>
	 * Remark: storing this reference is redundant, but makes the data structure faster when dealing with polygonal faces. */
	public Halfedge<X> prev;
	
	/** a reference to face incident to (containing) this half-edge. <br>
	 * Remark: this reference can be NULL, when the half-edge is a boundary edge. */
	public Face<X> face;
	
	/** an integer that can be used to tag half-edges (useful for dealing with colors, ...) */
	public int tag;

	/** an integer that can be used to index half-edges (useful for some applications) */
	public int index;

	public void setNext(Halfedge<X> e) { this.next=e; }
	public void setOpposite(Halfedge<X> e) { this.opposite=e; }
	public void setPrev(Halfedge<X> e) { this.prev=e; }
	public void setVertex(Vertex<X> v) { this.vertex=v; }
	public void setFace(Face<X> f) { this.face=f; }

	public Halfedge<X> getNext() { return this.next; }
	public Halfedge<X> getOpposite() { return this.opposite; }
	public Halfedge<X> getPrev() { return this.prev; }
	public Vertex<X> getVertex() { return this.vertex; }
	public Face<X> getFace() { return this.face; }

	public Halfedge() {}

	public String toString(){
		return "e"+this.index+" ("+opposite.getVertex().index+" - "+vertex.index+")";
	}

}


