package Jcg.meshgeneration;

import java.util.LinkedList;

import Jcg.geometry.Point_3;
import Jcg.mesh.MeshBuilder;
import Jcg.polyhedron.Face;
import Jcg.polyhedron.Polyhedron_3;

/**
 * Generate stacked triangulations, performing the recursive subdivision of triangulation consisting of two triangles
 * 
 * @author Luca Castelli Aleardi (Ecole Polytechnique, 2019)
 *
 */
public class StackedGeneration {
	/** the generated mesh to output */
	public Polyhedron_3<Point_3> polyhedron3D;
	public Face<Point_3> outerFace;

	public StackedGeneration() {
		int n=3; // create a triangle mesh consisting of only two faces
		int f=2;
        Point_3[] points=new Point_3[n];
        int[] faceDegrees=new int[f];
        int[][] faces=new int[f][3];
        
        double alpha=-Math.PI/6.; // -30 degrees
        double beta=7*Math.PI/6.; // 210 degrees
        points[0]=new Point_3(Math.cos(beta), Math.sin(beta), 0.0);
        points[1]=new Point_3(Math.cos(alpha), Math.sin(alpha), 0.0);
        points[2]=new Point_3(0.0, 1.0, 0.0);
        
        for(int i=0;i<f;i++)
        	faceDegrees[i]=3;
        
        faces[0]=new int[] {2, 1, 0};
        faces[1]=new int[] {0, 1, 2};
		
		MeshBuilder<Point_3> builder=new MeshBuilder<Point_3>();
		this.polyhedron3D=builder.createMesh(points, faceDegrees, faces);
		this.outerFace=this.polyhedron3D.facets.get(0);
		//this.polyhedron3D.isValid(false);
	}

	/**
	 * Subdivide all faces once, except the outer (infinite) face. Add a degree 3 vertex in each face.
	 */
	private void subdivideAllFacesOnce() {
		LinkedList<Face<Point_3>> faces=new LinkedList<Face<Point_3>>(); // store the original faces, before subdivision
		for(Face<Point_3> face: this.polyhedron3D.facets) {
			if(face!=this.outerFace)
				faces.add(face); // the outer face nust not be subdivided
		}
		
		for(Face<Point_3> face: faces) {
			Point_3 center=(Point_3)face.getBarycenter();
					
			this.polyhedron3D.createCenterVertex(face, center);
		}
	}

	/**
	 * Subdivide all faces 'i' times, except the outer (infinite) face.
	 */
	public void subdivideAllFaces(int iterations) {
		for(int i=0;i<iterations;i++)
			this.subdivideAllFacesOnce();
		
		this.polyhedron3D.isValid(false);
	}

}
