package Jcg.meshgeneration;

import tc.TC;

public class Conversion {

	/**
	 * It takes as input a text file storing a 2D triangulation and it returns as output 
	 * a 3D triangle mesh (closed genus 0 triangulation). <br>
	 * 
	 * Warnings: <br>
	 * -) the triangulation contains a 'dummy' (infinite) vertex v0 (its index is 0) <br>
	 * -) the coordinates of v0 are not stored: so, in the cgal file, there are N-1 vertices
	 * 
	 * @param filename  input file storing a Delaunay triangulation (computed with Cgal)
	 */
	public static void convertCgalToOFF(String filename, String output) {
		System.out.println("Converting Cgal 2D Delaunay triangulation to OFF format\nInput file: \t"+filename);
		System.out.println("Output file: \t"+output);
		
		System.out.print("Starting mesh conversion...");
		TC.lectureDansFichier(filename);
		TC.ecritureDansNouveauFichier(output);
		
		String ligne=TC.lireLigne();
		TC.println("OFF");	
		TC.println(ligne);
		
		String[] w=TC.motsDeChaine(ligne);
		int N=Integer.parseInt(w[0]);
		int F=Integer.parseInt(w[1]);
		
		TC.println("0.0 0.0 1.0"); // dummy vertex (connected to all boundary vertices of the Delaunay triangulation)
		for(int i=0;i<N-1;i++) { // observe that the dummy vertex is not stored in the cgal file: it has index 0
			ligne=TC.lireLigne();
			TC.println(ligne+" 0.0");
		}
		
		TC.lireLigne(); // there is an empty line
		for(int i=0;i<F;i++) {
			ligne=TC.lireLigne();
			TC.println("3 "+ligne);
		}
		
		TC.lectureEntreeStandard();
		TC.ecritureSortieStandard();
		
		System.out.println("done");
	}
	
	public static void main(String[] args) {
		System.out.println("Mesh converter: CgalToOFF");
		if(args.length<1) {
			System.out.println("Error: 1 parameter required");
			System.exit(0);
		}
		
		String input=args[0];
		String output=input.replaceAll(".cgal", ".off");
		convertCgalToOFF(args[0], output);
	}
	
}
