package Jcg.mesh;

import Jcg.geometry.Point_2;
import Jcg.geometry.Point_3;
import Jcg.meshgeneration.RandomSamplingTriangulations;
import Jcg.polyhedron.Polyhedron_3;

public class MeshLoader {

	/**
	 * Load a planar mesh embedded in 2D (Polyhedron_3<Point_2>) from an .off file
	 * It uses a shared vertex representation as intermediate data structure
	 */
	public static Polyhedron_3<Point_2> getPlanarMesh(String filename) {
		SharedVertexRepresentation m=new SharedVertexRepresentation(filename);    	
    	MeshBuilder<Point_2> load2D=new MeshBuilder<Point_2>();
    	Point_2[] points2D=MeshBuilder.Point3DToPoint2D(m.points);
    	Polyhedron_3<Point_2> planarTriangleMesh=
     		load2D.createMesh(points2D, m.faceDegrees, m.faces);

    	planarTriangleMesh.isValid(false);
    	return planarTriangleMesh;
	}

	/**
	 * Load a surface mesh embedded in 3D (Polyhedron_3<Point_3>) from an OFF or OBJ file
	 * It uses a shared vertex representation as intermediate data structure
	 */
	public static Polyhedron_3<Point_3> getSurfaceMesh(String filename) {
		SharedVertexRepresentation m;
		
		if(filename.endsWith(".OFF") || filename.endsWith(".off"))
			m=new SharedVertexRepresentation(filename);
		else if(filename.endsWith(".OBJ") || filename.endsWith(".obj"))
			m=SharedVertexRepresentation.readOBJ(filename);
		else
			throw new Error("Error: wrong mesh format (only OFF and OBJ format are supported");
    	
    	MeshBuilder<Point_3> load3D=new MeshBuilder<Point_3>();
    	Polyhedron_3<Point_3> triangleMesh=load3D.createMesh(m.points, m.faceDegrees, m.faces);

    	triangleMesh.isValid(false);
    	return triangleMesh;
	}

	/**
	 * Generating a random planar triangulation of size n+2 (with uniform distribution)
	 */
	public static Polyhedron_3<Point_2> getRandomPlanarTriangulation(int n) {
		throw new Error("To be updated");
		/*RandomSamplingTriangulations generator;
		generator=RandomSamplingTriangulations.randomTriangulation(n, false);
		return generator.poly;*/
	}
}
