package Jcg.geometry.kernel;

import Jcg.geometry.Point_3;
import Jcg.geometry.Segment_3;
import Jcg.geometry.Triangle_3;

/**
 * Interface defining geometric predicates for 3D objects (points, segments, rays)
 *
 * @author Luca Castelli Aleardi and Steve Oudot, Ecole Polytechnique (INF562)
 * @version feb 2014
 */
public interface GeometricPredicates_3 {

    /**
     * Intersection test between a segment and a triangle in 3D
     *
     * @param s a 3D segment
     * @param t a 3D triangle
     * @return true whether s and t do intersect, false otherwise
     */
    public boolean doIntersect(Segment_3 s, Triangle_3 t);

    /** 
     * Compute the orientation of tetrahedron
     * 
     * @param a point 3D (one vertex of a tetrahedron)
     * @param b point 3D (one vertex of a tetrahedron)
     * @param c point 3D (one vertex of a tetrahedron)
     * @param d point 3D (one vertex of a tetrahedron)
     * @return  +1 if orientation is direct, -1 if orientation is indirect, 0 if points are coplanar
     */
    public int orientation(Point_3 a, Point_3 b, Point_3 c, Point_3 d);

}
