package Jcg.geometry.kernel;

import Jcg.geometry.Point_2;
import Jcg.geometry.Ray_2;
import Jcg.geometry.Segment_2;

/**
 * Interface defining geometric predicates for plane objects (points, segments, rays)
 *
 * @author Luca Castelli Aleardi and Steve Oudot (INF562, Ecole Polytechnique)
 * @version 2.0, updated 12/11/2022 (created dec 2012)
 */
public interface GeometricPredicates_2 {

    /** 
    * Returns the orientation of a, b and c
    *
    * @param a,b,c the 3 points to test
    * @return 1 if sequence (a, b, c) turns in counter-clockwise direction, -1 if it turns in clockwise direction, 0 if the points are collinear
    */
    public int orientation (Point_2 a, Point_2 b, Point_2 c);
    
    /** Returns true if a, b and c turn in counter-clockwise direction
     * Warning: the result is false if the three points are collinear
     *
     * @param a,b,c the 3 points to test
     * @return true if a, b and c turn in counter-clockwise direction
     */
    public boolean isCounterClockwise(Point_2 a, Point_2 b, Point_2 c);
    
    /** Returns true if a, b and c turn in clockwise direction. <br>
     * Warning: the result is false if the three points are collinear
     *
     * @param a,b,c the 3 points to test
     * @return true if a, b and c turn in clockwise direction
     */
    public boolean isClockwise(Point_2 a, Point_2 b, Point_2 c);
     
    /** Returns true if a, b and c lie on a same line
    *
    * @param a,b,c the 3 points to test
    * @return true if a, b and c are collinear (lie on a same line)
    */
   public boolean collinear(Point_2 a, Point_2 b, Point_2 c);

   /**
     * Tests if point p lies inside the circumcircle of triangle a,b,c
     *
     * @param a,b,c triangle
     * @param p point to test
     * @return  true/false
     */
    public boolean inCircle(Point_2 p, Point_2 a, Point_2 b, Point_2 c);


    /**
    * Returns true if segments s and t intersect
    * @param s,t the 2 segments
    * @return true if s,t intersect each other
    */
   public boolean doIntersect(Segment_2 s, Segment_2 t);


  /** 
   * Returns true if segment s and ray r intersect
   *
   * @param s the segment
   * @param r the ray
   * @return true if s intersects r
   */
  public boolean doIntersect(Segment_2 s, Ray_2 r);

    /** 
     * Returns true if point p lies on segment ab
     *
     * @param a,b,p the 3 points
     * @return true if ab contains point p
     */    
 public boolean liesOn(Point_2 p, Point_2 a, Point_2 b);

}
