package Jcg.geometry.kernel;

import Jcg.geometry.Point_2;
import Jcg.geometry.Ray_2;
import Jcg.geometry.Segment_2;

/**
 * Interface defining geometric constructions for plane objects (points, segments, rays)
 *
 * @author Luca Castelli Aleardi and Steve Oudot, Ecole Polytechnique (INF562)
 * @version dec 2012
 */
public interface GeometricConstructions_2 {

    /**
     * Returns the (approximate) circumcenter of input triangle
     *
     * @param p0,p1,p2 the three vertices of the triangle
     *
     */
 	public Point_2 circumCenter (Point_2 p0, Point_2 p1, Point_2 p2);

	/**
     * Returns the distance (non exact computation) of a point to a segment
     *
     * @param ps,pe the start/end of the segment
     * @param p the query point
     * @return the distance of p to [ps,pe]
     */
    public Number distanceToSegment(Point_2 ps, Point_2 pe, Point_2 p);
    
    /** 
     * Returns approximate intersection between segments
     * 
     * @param s,t the 2 segments
     * @return approximate intersection point of s,t
     *
     */
    public Point_2 intersect(Segment_2 s, Segment_2 t);
    
    /** 
     * Returns approximate intersection between segment s and ray r
     *
     * @param s the segment
     * @param r the ray
     *
     * @return the intersection of s and r
     *
     */
    public Point_2 intersect(Segment_2 s, Ray_2 r);

}
