package Jcg.geometry.kernel;

import Jcg.geometry.Algebra;
import Jcg.geometry.Point_3;

/**
 * Approximate geometric constructions for 3D objects (points, segments, rays)
 *
 * @author Luca Castelli Aleardi and Steve Oudot, Ecole Polytechnique (INF562)
 * @version dec 2012
 */
public class ApproximateConstructions_3 implements GeometricConstructions_3 {
	
    /**
     * Returns the (approximate) circumcenter of four points
     *
     * @param p,q,s,r the four input points
     *
     */
	public Point_3 circumCenter (Point_3 p, Point_3 q, Point_3 r, Point_3 s) {
        // Translate p to origin to simplify the expression.
        double qpx = q.getX().doubleValue()-p.getX().doubleValue();
        double qpy = q.getY().doubleValue()-p.getY().doubleValue();
        double qpz = q.getZ().doubleValue()-p.getZ().doubleValue();
        double qp2 = qpx*qpx + qpy*qpy + qpz*qpz;
        double rpx = r.getX().doubleValue()-p.getX().doubleValue();
        double rpy = r.getY().doubleValue()-p.getY().doubleValue();
        double rpz = r.getZ().doubleValue()-p.getZ().doubleValue();
        double rp2 = rpx*rpx + rpy*rpy + rpz*rpz;
        double spx = s.getX().doubleValue()-p.getX().doubleValue();
        double spy = s.getY().doubleValue()-p.getY().doubleValue();
        double spz = s.getZ().doubleValue()-p.getZ().doubleValue();
        double sp2 = spx*spx + spy*spy + spz*spz;

        double num_x = Algebra.det33 (new double[] {qpy,qpz,qp2,
       		 rpy,rpz,rp2, spy,spz,sp2});
        double num_y = Algebra.det33 (new double[] {qpx,qpz,qp2,
       		 rpx,rpz,rp2, spx,spz,sp2});
        double num_z = Algebra.det33 (new double[] {qpx,qpy,qp2,
       		 rpx,rpy,rp2, spx,spy,sp2});
        double den = Algebra.det33 (new double[] {qpx,qpy,qpz,
       		 rpx,rpy,rpz, spx,spy,spz});
        double inv = 1.0 / (2.0 * den);

        double x = p.getX().doubleValue() + num_x*inv;
        double y = p.getY().doubleValue() - num_y*inv;
        double z = p.getZ().doubleValue() + num_z*inv;
        return new Point_3 (x, y, z);

    }

}
