package Jcg.geometry;

/**
 * An interface defining primivites and operations on vectors in euclidean space
 *
 * @author Luca Castelli Aleardi (Ecole Polytechnique, 2010)
 */
public interface Vector_ {
	
	/**
	 * return the i-th cartesian coordinate of the point
	 */
	  public Number getCartesian(int i);  
		
	  /**
	   * set the i-th cartesian coordinate
	   */
	  public void setCartesian(int i, Number x);
	  
	  /**
	   * Return the vector sum (v+u), where u is the current vector
	   */
	  public Vector_ sum(Vector_ v);
	  	
	  /**
	   * Return the vector difference (v-u), where u is the current vector
	   */
	  public Vector_ difference(Vector_ v);
	  	
	  /**
	   * Return the opposite of the current vector
	   */
	  public Vector_ opposite();

	  /**
	   * Return the inner product of two vectors
	   */
	  public Number innerProduct(Vector_ v);

	  /**
	   * Return a new vector obtained by scalar division
	   */
	  public Vector_ divisionByScalar(Number s);

	  /**
	   * Return a new vector obtained by multiplying by a scalar
	   */
	  public Vector_ multiplyByScalar(Number s);
	  
	  /**
	   * Return the square length of a vector
	   */
	  public Number squaredLength();
	   
	  /**
	   * Return the dimension of the space
	   */
	  public int dimension();

	  /**
	   * Return a String representing vector coordinates
	   */
	  public String toString();
}
