package Jcg.geometry;

import java.util.ArrayList;
import java.util.Collection;

/**
 * Class representing a polyline in the plane (ordered sequence of points in 2D)
 *
 * @author Luca Castelli Aleardi, Ecole Polytechnique (INF562)
 * @version dec 2012
 */
public class PolyLine_2 extends PointCloud_2 implements PolyLine_<Point_2> {

	/**
	 * Create a new empty polyline
	 */
	public PolyLine_2() {
		super();
	}

	/**
	 * Create a polyline of size n
	 * @param n number of points
	 */
	public PolyLine_2(int n) {
		super(n);
	}
	
	/**
	 * Create a new polyline (a copy of the list is created) from a collection of points
	 * @param points a collection of points
	 */
	public PolyLine_2(ArrayList<Point_2> points) {
		super(points);
	}

	/**
	 * Create a polyline from a point cloud (there is no copy of the list)
	 * @param a point cloud
	 */
	public PolyLine_2(PointCloud_2 pointCloud) {
		this.points=pointCloud.points;
		this.dimension=2;
	}

	public void addFirst(Point_2 p) {
		if(p==null)
			return;
		this.points.add(0, p);
	}

	public void addLast(Point_2 p) {
		if(p==null)
			return;
		this.points.add(p);
	}

	/**
	 * Compute and return the list of segments defining the polyline
	 */
	public Collection<Segment_2> computeSegments() {
		ArrayList<Segment_2> result=new ArrayList<Segment_2>();
		for(int i=0;i<this.size()-1;i++) {
			Segment_2 s=new Segment_2(this.points.get(i), this.points.get(i+1));
			result.add(s);
		}
		return result;
	}

}
