package Jcg.geometry;

/**
 * An interface defining geometric primitives and operations on points in euclidean space
 *
 * @author Luca Castelli Aleardi (Ecole Polytechnique, INF562, 2010-2022)
 */
public interface Point_ extends Comparable<Point_> {
	
	/**
	 * return the i-th cartesian coordinate of the point
	 */
	public Number getCartesian(int i);  

	/**
	 * set the i-th cartesian coordinate
	 */
	public void setCartesian(int i, Number x);

	/**
	 * set the coordinates of the origin
	 */	  
	public void setOrigin();

	/**
	 * Translate the current point according to a vector v
	 */	  
	public void translateOf(Vector_ v);

	/**
	 * Return the vector (p-q), where q is the current point
	 */
	public Vector_ minus(Point_ p);

	/**
	 * Return the square distance ||p-q||^2, where q is the current point
	 */
	public Number squareDistance(Point_ p);

	/**
	 * Set the current point as the barycenter of an array of points
	 */	  
	public void barycenter(Point_ [] points);

	/**
	 * Set the current point a linear combination of an array of points.
	 * Coefficients must sum to 1
	 */	  
	public void linearCombination(Point_[] points, Number[] coefficients);

	/**
	 * Return the dimension of the space
	 */	  
	public int dimension();

	/**
	 * Return a string (representation of the point)
	 */	  
	public String toString();

	/**
	 * Perform the comparison between the i-th coordinate of two points
	 */	  
	public int compareCartesian(Point_ o, int i);

}

class Orientation {

	static int CLOCKWISE=1;
	static int COUNTERCLOCKWISE=-1;
	static int COLLINEAR=0;

	private int or;

	public Orientation(int or) {
		this.or=or;
	}

	public boolean isClockwise() {
		return this.or == CLOCKWISE;
	}

	public boolean isCounterclockwise() {
		return this.or == COUNTERCLOCKWISE;
	}

	public boolean isCollinear() {
		return this.or == COLLINEAR;
	}
}


