package Jcg.geometry;

import java.util.ArrayList;

/**
 * Class representing a collection of points (in dimension d)
 *
 * @author Luca Castelli Aleardi, Ecole Polytechnique (INF562)
 * @version jan 2014
 */
public class PointCloud_d extends PointCloud<Point_d> {


	/**
	 * Create a new empty point cloud
	 */
	public PointCloud_d(int d) {
		this.points=new ArrayList<Point_d>();
		this.dimension=d;
	}

	/**
	 * Create a point cloud of size n
	 * @param n number of points
	 */
	public PointCloud_d(int n, int d) {
		this.points=new ArrayList<Point_d>(n);
		this.dimension=d;
	}
	
	/**
	 * Create a new point cloud (a copy) from a collection of points
	 * @param a list of points (stored as an ArrayList)
	 */
	public PointCloud_d(ArrayList<Point_d> points) {
		this.points=new ArrayList<Point_d>();
		//this.dimension=3;
		for(Point_d p: points)
			this.points.add(p);
	}

	/**
     * Compute the bounding box (enclosing all points)
     * 
     * @return Point_3[] the array containing the min and max bounds
     */		
	public Point_d[] boundingBox() {
		if(this.size()==0)
			return null;
		
		Point_d[] result=new Point_d[2]; // two extremities of the bounding box
		throw new Error("To be completed");
		//result[0]=new Point_3(min(0).getX(), min(1).getY(), min(2).getZ()); // left bottom vertex
		//result[1]=new Point_3(max(0).getX(), max(1).getY(), max(2).getZ()); // right top vertex
		//return result;
	}

	/**
     * Return the point with greatest coordinate value (in direction d)
     * @param d dimension (0 or 1, corresponding to x or y axis)
     * @return Point_2 the greatest point (with greatest d-coordinate)
     */		
	public Point_d max(int d) {
		if(this.size()==0)
			return null;
		
  		Point_d maxPoint=null;  		
 		double maxCoordinate=Double.MIN_VALUE;
 		
  		for(Point_d p: this.points) {
  			if(p.getCartesian(d).doubleValue()>maxCoordinate) {
  				maxPoint=p;
  				maxCoordinate=p.getCartesian(d).doubleValue();
  			}
  		}
  		return maxPoint;
	}
	
	/**
     * Return the point with smallest coordinate value (in direction d)
     * @param d dimension (0 or 1, corresponding to x or y axis)
     * @return Point_2 the smallest point (with smallest d-coordinate)
     */		
	public Point_d min(int d) {
		if(this.size()==0)
			return null;
		
  		Point_d minPoint=null;  		
 		double minCoordinate=Double.MAX_VALUE;
 		
  		for(Point_d p: this.points) {
  			if(p.getCartesian(d).doubleValue()<minCoordinate) {
  				minPoint=p;
  				minCoordinate=p.getCartesian(d).doubleValue();
  			}
  		}
  		return minPoint;
	}
	
	/**
	 * Generate points inside a d-dimensional sphere at random
	 * @param n the number of points
	 */
	public static PointCloud_d pointsInSphere(int n, int d) {
    	ArrayList<Point_d> points = new ArrayList<Point_d>();
   		Point_d origin=new Point_d(d);
    	for (int i=0; i<n;) {
    		double[] randomCoordinates=new double[d];
    		for(int k=0;k<d;k++)
    			randomCoordinates[k]=10.-20*Math.random();

     		Point_d p=new Point_d(randomCoordinates); 
     		if (p.squareDistance(origin).doubleValue() <= 100.) {
    			points.add (p);
    			i++;
    		}
    	}
    	return new PointCloud_d(points);
	}

}
