package Jcg.geometry;

import java.util.ArrayList;

/**
 * Class representing a collection of points (in 3D)
 *
 * @author Luca Castelli Aleardi, Ecole Polytechnique (INF562)
 * @version jan 2014
 */
public class PointCloud_3 extends PointCloud<Point_3> {


	/**
	 * Create a new empty point cloud
	 */
	public PointCloud_3() {
		this.points=new ArrayList<Point_3>();
		this.dimension=3;
	}

	/**
	 * Create a point cloud of size n
	 * @param n number of points
	 */
	public PointCloud_3(int n) {
		this.points=new ArrayList<Point_3>(n);
		this.dimension=3;
	}
	
	/**
	 * Create a new point cloud (a copy) from a collection of points
	 * @param points list of points (stored as an ArrayList)
	 */
	public PointCloud_3(ArrayList<Point_3> points) {
		this.points=new ArrayList<Point_3>();
		this.dimension=3;
		for(Point_3 p: points)
			this.points.add(p);
	}

	/**
     * Compute the bounding box (enclosing all points)
     * 
     * @return a Point_3[] array containing the min and max bounds
     */		
	public Point_3[] boundingBox() {
		if(this.size()==0)
			return null;
		
		Point_3[] result=new Point_3[2]; // two extremities of the bounding box
		result[0]=new Point_3(min(0).getX(), min(1).getY(), min(2).getZ()); // left bottom vertex
		result[1]=new Point_3(max(0).getX(), max(1).getY(), max(2).getZ()); // right top vertex
		return result;
	}

	/**
     * Return the point with greatest coordinate value (in direction d)
     * @param d dimension (0, 1 or 2, corresponding to x or y axis)
     * @return Point_2 the greatest point (with greatest d-coordinate)
     */		
	public Point_3 max(int d) {
		if(this.size()==0)
			return null;
		
  		Point_3 maxPoint=null;  		
 		double maxCoordinate=Double.MIN_VALUE;
 		
  		for(Point_3 p: this.points) {
  			if(p.getCartesian(d).doubleValue()>maxCoordinate) {
  				maxPoint=p;
  				maxCoordinate=p.getCartesian(d).doubleValue();
  			}
  		}
  		return maxPoint;
	}
	
	/**
     * Return the point with smallest coordinate value (in direction d)
     * @param d dimension (0,1 or 2, corresponding to x or y axis)
     * @return Point_2 the smallest point (with smallest d-coordinate)
     */		
	public Point_3 min(int d) {
		if(this.size()==0)
			return null;
		
  		Point_3 minPoint=null;  		
 		double minCoordinate=Double.MAX_VALUE;
 		
  		for(Point_3 p: this.points) {
  			if(p.getCartesian(d).doubleValue()<minCoordinate) {
  				minPoint=p;
  				minCoordinate=p.getCartesian(d).doubleValue();
  			}
  		}
  		return minPoint;
	}
	
	/**
	 * Generate points inside a sphere at random
	 * @param n the number of points
	 */
	public static PointCloud_3 pointsInSphere(int n) {
    	ArrayList<Point_3> points = new ArrayList<Point_3>();
    	for (int i=0; i<n;) {
    		Point_3 p = new Point_3 (10.-20*Math.random(), 10.-20*Math.random(), 10.-20*Math.random());
    		if (p.squareDistance(new Point_3(0.,0., 0.)).doubleValue() <= 100.) {
    			points.add (p);
    			i++;
    		}
    	}
    	return new PointCloud_3(points);
	}

}
