package Jcg.geometry;

import java.util.ArrayList;

/**
 * Class representing a collection of points (in 2D)
 *
 * @author Luca Castelli Aleardi, Ecole Polytechnique (INF562)
 * @version dec 2012
 */
public class PointCloud_2 extends PointCloud<Point_2> {

	/**
	 * Create a new empty point cloud
	 */
	public PointCloud_2() {
		this.points=new ArrayList<Point_2>();
		this.dimension=2;
	}

	/**
	 * Create a point cloud of size n
	 * @param n number of points
	 */
	public PointCloud_2(int n) {
		this.points=new ArrayList<Point_2>(n);
		this.dimension=2;
	}
	
	/**
	 * Create a new point cloud (a copy) from a collection of points
	 * @param a list of points (stored as an ArrayList)
	 */
	public PointCloud_2(ArrayList<Point_2> points) {
		this.points=new ArrayList<Point_2>();
		this.dimension=2;
		for(Point_2 p: points)
			this.points.add(p);
	}

	/**
     * Compute the bounding box (enclosing all points)
     * 
     * @return Point_2[] the array containing the min and max bounds
     */		
	public Point_2[] boundingBox() {
		if(this.size()==0)
			return null;
		
		Point_2[] result=new Point_2[2]; // two extremities of the bounding box
		result[0]=new Point_2(min(0).getX(), min(1).getY()); // left bottom vertex
		result[1]=new Point_2(max(0).getX(), max(1).getY()); // right top vertex
		return result;
	}

	/**
     * Return the point with greatest coordinate value (in direction d)
     * @param d dimension (0 or 1, corresponding to x or y axis)
     * @return Point_2 the greatest point (with greatest d-coordinate)
     */		
	public Point_2 max(int d) {
		if(this.size()==0)
			return null;
		
  		Point_2 maxPoint=null;  		
 		double maxCoordinate=Double.MIN_VALUE;
 		
  		for(Point_2 p: this.points) {
  			if(p.getCartesian(d).doubleValue()>maxCoordinate) {
  				maxPoint=p;
  				maxCoordinate=p.getCartesian(d).doubleValue();
  			}
  		}
  		return maxPoint;
	}
	
	/**
     * Return the point with smallest coordinate value (in direction d)
     * @param d dimension (0 or 1, corresponding to x or y axis)
     * @return Point_2 the smallest point (with smallest d-coordinate)
     */		
	public Point_2 min(int d) {
		if(this.size()==0)
			return null;
		
  		Point_2 minPoint=null;  		
 		double minCoordinate=Double.MAX_VALUE;
 		
  		for(Point_2 p: this.points) {
  			if(p.getCartesian(d).doubleValue()<minCoordinate) {
  				minPoint=p;
  				minCoordinate=p.getCartesian(d).doubleValue();
  			}
  		}
  		return minPoint;
	}
	
	/**
	 * Generate points inside a circle at random
	 * @param n the number of points
	 */
	public static PointCloud_2 pointsInCircle(int n) {
    	ArrayList<Point_2> points = new ArrayList<Point_2>();
    	for (int i=0; i<n;) {
    		Point_2 p = new Point_2 (10.-20*Math.random(), 10.-20*Math.random());
    		if (p.squareDistance(new Point_2(0.,0.)).doubleValue() <= 100.) {
    			points.add (p);
    			i++;
    		}
    	}
    	return new PointCloud_2(points);
	}

}
