package Jcg.geometry;

import java.util.ArrayList;
import java.util.Collection;

/**
 * Class representing a collection of points (in arbitrary dimension)
 *
 * @author Luca Castelli Aleardi, Ecole Polytechnique (INF562)
 * @version dec 2012
 */
public abstract class PointCloud<X extends Point_> {
	
	protected ArrayList<X> points; // collection of points
	protected int dimension; // dimension of the ambient space
		
	/**
	 * Return the size of the point cloud
	 * @return n the number of points
	 */
	public int size() {
		return this.points.size();
	}
	
	/**
	 * Return the dimension of the space
	 * @return d the dimension
	 */
	public int dimension() {
		return this.dimension;
	}

	/**
	 * Add a new point to the point cloud
	 * @param p the point to add
	 */
	public void add(X p) {
		this.points.add(p);
	}

	/**
	 * Remove a point to the point cloud
	 * @param p the point to remove
	 */
	public void remove(X p) {
		this.points.remove(p);
	}
	
	/**
	 * Return the list of points
	 * @return Collection<X> the list of points
	 */
	public Collection<X> listOfPoints() {
		return this.points;
	}
	
	/**
     * Compute the bounding box (enclosing all points)
     * 
     * @return X[] the array containing the min and max bounds
     */		
	public abstract X[] boundingBox();

	/**
     * Return the point with smallest coordinate value (in direction d)
     * @param d dimension
     * @return X the smallest point (with smallest d-coordinate)
     */		
	public abstract X min(int d);

	/**
     * Return the point with greatest coordinate value (in direction d)
     * @param d dimension
     * @return X the greatest point (with greatest d-coordinate)
     */		
	public abstract X max(int d);

}
