package Jcg.geometry;

import java.math.BigInteger;

public class GridVector_2 implements Vector_ {
	public int x,y;

	public GridVector_2() {}

	public GridVector_2(int x, int y) { 
		this.x=x; 
		this.y=y;
	}

	public GridVector_2(GridPoint_2 a, GridPoint_2 b) { 
		this.x=b.getX()-a.getX(); 
		this.y=b.getY()-a.getY(); 
	}

	public int getX() {return x; }
	public int getY() {return y; }

	public void setX(int x) {this.x=x; }
	public void setY(int y) {this.y=y; }


	public boolean equals(Object o) {
		GridVector_2 v;
		  if (o instanceof GridVector_2) {
			  v = (GridVector_2) o;
			  return this.x==v.getCartesian(0) && this.y==v.getCartesian(1); 
		  }
		  throw new RuntimeException ("Method equals: comparing Point_2 with object of type " + o.getClass());  	
	}

	public String toString() {return "["+x+","+y+"]"; }
	public int dimension() { return 2;}

	public Integer getCartesian(int i) {
		if(i==0) return x;
		return y;
	} 

	public void setCartesian(int i, Number value) {
		if(i==0) this.x=value.intValue();
		else this.y=value.intValue();
	}

	public GridVector_2 sum(Vector_ v) {
		return new GridVector_2(v.getCartesian(0).intValue()+x, v.getCartesian(1).intValue()+y);  	
	}

	public GridVector_2 difference(Vector_ v) {
		return new GridVector_2(v.getCartesian(0).intValue()-x, v.getCartesian(1).intValue()-y);  	
	}

	public GridVector_2 opposite() {
		return new GridVector_2(-x,-y);  	
	}

	/**
	 * A conversion from int to long is necessary to avoid overflows
	 * @param v
	 * @return this . v
	 */
	public Number innerProduct(Vector_ v) {
		long result=(long)(this.x) * (long)(v.getCartesian(0).intValue()) + (long)(this.y) * (long)(v.getCartesian(1).intValue());
		return Long.valueOf(result);
	}

	/**
	 * A conversion from int to long is necessary to avoid overflows
	 * @param v
	 * @return this ^ v
	 */
	public long crossProduct(GridVector_2 v) {
		return (long)(this.x) * (long)(v.y) - (long)(v.x) * (long)(this.y);
	}

	public boolean colinear(GridVector_2 v) {
		return this.crossProduct(v) == 0;
	}

	public Vector_2 divisionByScalar(Number s) {
		//return new Vector_2(x/s.doubleValue(),y/s.doubleValue());
		throw new Error("Not implemented yet");
	}

	public GridVector_2 multiplyByScalar(Number s) {
		//return new GridVector_2(x*s,y*s);
		throw new Error("Not implemented yet");
	}

	public Number squaredLength() {
		return innerProduct(this);  	
	}

}




