import Jcg.geometry.Point_d;

/**
 * Class for testing and benchmarking range search methods
 * 
 * @author Luca Castelli Aleardi (Ecole Polytechnique, INF562)
 * @version jan 2014
 */
public class TestRangeSearch {
	
	static long queryTime=0;
	static long constructionTime=0;
	static long basicQueryTime=0;    

	/**
	 * Show time performances
	 */
	public static void showTimePerformances() {
		System.out.println("Range Search performaces:\nTotal construction time: " + constructionTime/1000 + "s " + 
				constructionTime%1000 + "ms");   	
		System.out.println("Total NN query time: " + queryTime/1000 + "s " + 
				queryTime%1000 + "ms\n");   	
	}

	/**
	 * Main test function, for testing 2D and 3D range search
	 */
	public static void main(String args[]) {
		System.out.println("Exo 1.3: testing Range Search");
		PointCloud N; // input point cloud
		double radius=5.2; // radius of the query ball
		
		if (args.length < 1) {
			N=PointCloud.randomPoints(3000, 3);
		}
		else { 
			N=IO.pointsFromDataFile(args[0]);
		}

		Point_d query=N.p; // query point

		System.out.print("Computing Kd-Tree data structure... ");
		RangeSearch<Point_d> fastSearch=new FastRangeSearch<Point_d>(N);
		System.out.println(" done");
		RangeSearch<Point_d> slowSearch=new SlowRangeSearch<Point_d>(N);
		if(N.p.dimension()==3) {
			Draw.draw3D(N); // draw original point cloud in 3D
		}
		else if(N.p.dimension()==2) {
			Draw.draw2D(N, "original point cloud");
		}
		else {
			throw new Error("Error point dimension");
		}

		PointCloud neighbors1=slowSearch.OrthogonalRangeSearch(query, radius);
		PointCloud neighbors2=fastSearch.OrthogonalRangeSearch(query, radius);
		System.out.println("basic search: "+PointCloud.size(neighbors1)+" neighbors");
		System.out.println("Kd-Trees search: "+PointCloud.size(neighbors2)+" neighbors");
		
		if(N.p.dimension()==2) {
			Draw.draw2D(neighbors1, "Slow range search: basic (linear) scan");    	
			Draw.draw2D(neighbors2, "Fast range search with Kd-Trees");
		}
		else if(N.p.dimension()==3) {
			Draw.draw3D(neighbors1);
			Draw.draw3D(neighbors2);			
		}

		System.out.print("Check correctness Range Search...");
		if(PointCloud.size(neighbors1)!=PointCloud.size(neighbors2))
			throw new Error("error: wrong number of neighbors");
		System.out.println("ok");
		
		FastRangeSearch.timePerformance();
	}

}
