import Jcg.geometry.Point_d;

/**
 * This class contains methods for testing the Kd-tree data structure
 * 
 * @author Luca Castelli Aleardi (Ecole Polytechnique, INF562)
 * @version jan 2014
 */
public class TestMedian {

	public static void main(String[ ] args) throws Exception {
		System.out.println("Exercice 1: testing Kd-trees");
		PointCloud N;

		if (args.length < 1) {
			//N=PointCloud.randomPoints(3000, 3);
			N=PointCloud.randomPointsOnCircle(3000, 3);
		}
		else { 
			N=IO.pointsFromDataFile(args[0]);
		}
		if(N.p.dimension()==2)
			Draw.draw2D(N, "original point cloud");
		else if(N.p.dimension()==3)
			Draw.draw3D(N);

		testMedianComputing(N);

		System.out.println("end");
	}

	public static void testMedianComputing(PointCloud N) {
		System.out.println("exercice 1.1: computing the median (or the mean)");
		if(N==null)
			return;
		int cutDim=1; // cut along y direction

		Median median; // choice of the median computation
		//median=new LinearTimeMedian(N);
		median=new MedianWithSorting(N);
		Point_d p; // median point
		p=median.findMedian(cutDim);
		double value=p.getCartesian(cutDim).doubleValue(); // cut value
		PointCloud[] subN=KdTree.split(N, value, cutDim); // split input points

		System.out.println("size original point cloud: "+PointCloud.size(N));
		System.out.println("size lower half: "+PointCloud.size(subN[0]));
		System.out.println("size upper half: "+PointCloud.size(subN[1]));

		if(N.p.dimension()==2) {
			Draw.draw2D(subN[0], "lower points");
			Draw.draw2D(subN[1], "upper points");
		}
		if(N.p.dimension()==3) {
			Draw.draw3D(subN[0]);
			Draw.draw3D(subN[1]);
		}
	}

}
