import java.util.Calendar;

import Jcg.geometry.Point_d;

/**
 * This class contains methods for testing the Mean-Shift clustering
 * 
 * @author Luca Castelli Aleardi (Ecole Polytechnique, INF562)
 * @version jan 2014
 */
public class TestMeanShift {

	public static void main(String[ ] args) throws Exception {
		System.out.println("Exercice 2:");
		double bandWidth;
		PointCloud N=null;
		if (args.length < 1) {
			System.out.println("Usage: java MeanShiftClustering (datafile.dat) bandwidth");
			System.out.println("dataFile.dat optionnel");
			System.exit(0);
		}    	
		if (args.length == 1 ) {
			//N=PointCloud.randomPoints(3000, 3);
			N=PointCloud.randomPointsOnCircle(3000, 3);
			bandWidth = Double.parseDouble(args[0]);
		}
		else { 
			N=IO.pointsFromDataFile(args[0]);
			bandWidth = Double.parseDouble(args[1]);
		}

		System.out.println("point cloud of size: "+PointCloud.size(N));
		Draw.draw2D(N, "original point cloud");

		Calendar rightNow = Calendar.getInstance(); // to compute time performances
		long time0 = rightNow.getTimeInMillis();

		//--------- choose test to perform ---------------
		//testDetectCluster(N, bandWidth); // ex 2.1
		testMeanShift(N, bandWidth); // ex 2.3
		//------------------------------------------------

		rightNow = Calendar.getInstance(); // to compute time performances
		long time = rightNow.getTimeInMillis();
		System.out.println("Total time to find clusters: " + (time-time0)/1000 + "s " + (time-time0)%1000 + "ms");

	}

	public static void testMeanShift(PointCloud N, double bandwidth) {
		System.out.println("Exercice 2.3: testing Mean-Shift clustering");

		MeanShiftClustering msc = new MeanShiftClustering (N, bandwidth);

		Point_d[] clusterCenters = msc.computeClusters();
		int nDetectedClusters=0;
		for(int i=0;i<clusterCenters.length;i++)
			if(clusterCenters[i]!=null) 
				nDetectedClusters++;
		System.out.println("Number of clusters detected: "+nDetectedClusters);

		Draw.draw3D(N);
		Draw.draw3D(N, msc.clusters);
		//msc.Rs.timePerformance();
	}

	public static void testDetectCluster(PointCloud N, double bandwidth) {
		System.out.println("Exercice 2.1: testing cluster detection (only one cluster)");
		System.out.println("Input point cloud: "+PointCloud.size(N)+" points");

		MeanShiftClustering msc = new MeanShiftClustering (N, bandwidth);

		int clusterNumber=0;
		PointCloud detectedCluster=msc.detectCluster(N.next.p, clusterNumber);

		PointCloud t=detectedCluster;
		int i=0;
		while(t!=null) {
			if(msc.clusters.getClusterIndex(t.p)==clusterNumber)
				i++;
			t=t.next;
		}
		System.out.println("size of the detected cluster: "+PointCloud.size(detectedCluster));
		System.out.println("size of the cluster: "+i);

		Draw.draw3D(N); // draw original point cloud
		Draw.draw3D(N, msc.clusters); // draw detected cluster
		//msc.Rs.timePerformance();
	}

}
