import Jcg.geometry.Point_d;

/**
 * This class contains methods for testing the Kd-tree data structure
 * 
 * @author Luca Castelli Aleardi (Ecole Polytechnique, INF562)
 * @version jan 2014
 */
public class TestKdTree {

	public static void main(String[ ] args) throws Exception {
		System.out.println("Exercice 1.2: testing Kd-trees");
		PointCloud N;

		if (args.length < 1) {
			N=PointCloud.randomPoints(3000, 3);
		}
		else { 
			N=IO.pointsFromDataFile(args[0]);
		}
		Draw.draw2D(N, "original point cloud");
		Draw.draw3D(N);

		testConstructionKdTree(N);

		System.out.println("end");
	}
	
	public static void testConstructionKdTree(PointCloud N) {
		System.out.println("exercice 1.2: constructing the Kd-Tree");
		if(N==null) return;

		KdTree<Point_d> kdtree=KdTree.constructDataStructure(N, N.p.dimension());

		System.out.println("size original point cloud: "+PointCloud.size(N));
		System.out.println("size Kd-Tree (total number of nodes): "+KdTree.size(kdtree));
		System.out.println("number of leaves in the tree: "+KdTree.leavesNumber(kdtree));
		KdTree.checkBalance(kdtree);

	}

}
