import java.util.Calendar;
import java.awt.Color;
import java.awt.image.*;

import Jcg.geometry.*;
import Jcg.viewer.old.Fenetre;

class TestImageSegmentation {
	

	
	//-------------------------------    
	//--- Test image segmentation ---
	//--- no java code to write, only testing Mean-Shift algorithm on images data
	//-------------------------------


	public static void main(String[ ] args) throws Exception {
		System.out.println("Testing image segmentation: ex 3.1");

		if (args.length < 2) {
			System.out.println("Usage: java ImageSegmentation image bandwidth");
			System.exit(0);
		}

		double bandWidth = Double.parseDouble(args[1]);
		// load input image
		BufferedImage bimg = IO.loadImage(args[0]); 
		int dimx = bimg.getWidth();
		int dimy = bimg.getHeight();
		// get array of pixels from image, in L*u*v* space
		WritableRaster raster = bimg.getRaster(); 
		System.out.println("Pixels array created from image");

		// build point cloud from raster
		int dim = 3;
		PointCloud N = ImageManipulation.rasterToPointCloud (raster, dimx, dimy, dim);

		// draw input image and corresponding point cloud
		System.out.println ("dim = " + dim + ", size = " + PointCloud.size(N));
		Draw.draw3D(N);
		new Fenetre(bimg, "input image");

		System.out.print("\nPress <Enter> to start computation...");
		System.in.read();
		
		MeanShiftClustering msc = new MeanShiftClustering (N, bandWidth);	
		//ImageSegmentation msc = new ImageSegmentation (N, N, 0.001, 1.7, 0.001, 1.6);
		Calendar rightNow = Calendar.getInstance(); // to compute time performances
		long time0 = rightNow.getTimeInMillis();

		Point_d[] clusterCenters = msc.computeClusters();  // performing Mean-Shift algorithm

		rightNow = Calendar.getInstance(); // to compute time performances
		long time = rightNow.getTimeInMillis();
		System.out.println("\n Total time to find clusters: " + (time-time0)/1000 + "s " + (time-time0)%1000 + "ms");

		// Assign colors to clusters
		Color[] couleurs = new Color[clusterCenters.length];
		ImageManipulation.assignColors (clusterCenters.length, clusterCenters, couleurs);
		
		int countClusters=0; // count detected clusters
		while(countClusters<clusterCenters.length && clusterCenters[countClusters]!=null)
			countClusters++;
		System.out.println("\nCluster centers: "+countClusters);

		// move new data into raster, and from there into image
		ImageManipulation.PointCloudToRaster (N, msc.clusters, couleurs, raster, dimx, dimy, dim);
		bimg.setData(raster);

		Color[] finalColors=new Color[clusterCenters.length];
		PointCloud t=N;
		int i=0;
		while(t!=null) {
			finalColors[i]=couleurs[msc.clusters.getClusterIndex(t.p)];
			t=t.next;
			i++;
		}

		// draw clusters
		Draw.draw3D(N,finalColors);
		// draw new image (after segmentation)
		new Fenetre(bimg, "Output image");

		FastRangeSearch.timePerformance();

		System.out.println("Image Segmentation: end");
	}
}


