import java.awt.image.BufferedImage;

import Jcg.viewer.old.Fenetre;

/**
 * Testing input/output operations on data and image files
 * 
 * @author Luca Castelli Aleardi and Steve Oudot(Ecole Polytechnique, INF562)
 * @version jan 2014
 */
public class TestIO {

	public static void main(String[] args) {
		System.out.println("Exercice 0: preliminary tests (TD on clustering and image segmentation)");    
		System.out.println("Loading point cloud from data or image");    	    	
		if (args.length < 1) {
			System.out.println("Usage: java TestIO inputfile");
			System.exit(0);
		}
		
		PointCloud N=null; // input point cloud
		
		if(args[0].endsWith(".dat")) {
			N=IO.pointsFromDataFile(args[0]);
			if(N.p.dimension()==2)
				Draw.draw2D(N, "original point cloud");
			else if(N.p.dimension()==3)
				Draw.draw3D(N);
		}
		else if(args[0].endsWith(".jpg") || args[0].endsWith(".png") || args[0].endsWith(".bmp")) {
			N=IO.pointsFromImage(args[0]);
			Draw.draw3D(N);
			BufferedImage bimg = IO.loadImage(args[0]); 
			new Fenetre(bimg, "input image: "+args[0]);
		}
		
		if(N==null)
			throw new Error("Error: wrong input file");
		
		System.out.println("Point cloud: "+PointCloud.size(N)+" points");
	}  

}
