import java.util.LinkedList;

import Jcg.geometry.*;

/**
 * This class contains the main methods implementing the Mean-Shift clustering
 * 
 * @author Luca Castelli Aleardi and Steve Oudot (Ecole Polytechnique, INF562)
 * @version jan 2014
 */
public class MeanShiftClustering implements Clustering {
	// describes how points are assigned to clusters
	public Cluster<Point_d> clusters=new Cluster<Point_d>();
	
	PointCloud N; // input point cloud
	PointCloud seeds;
	double sqCvgRad;  // convergence radius
	double sqAvgRad;  // averaging radius (definining the window)
	double sqInflRad;  // influence radius
	double sqMergeRad;  // merging radius

	FastRangeSearch<Point_d> Rs;  // data structure for nearest neighbor search


	// Constructors

	void initMSC (PointCloud n, PointCloud s, double cr, double ar, double ir, double mr){
		N = n;
		seeds = s;
		sqCvgRad = cr*cr;
		sqAvgRad = ar*ar;
		sqInflRad = ir*ir;
		sqMergeRad = mr*mr;
		Rs = new FastRangeSearch<Point_d>(N);
	}

	MeanShiftClustering (PointCloud n, PointCloud s, 
			double cr, double ar, double ir, double mr) {
		initMSC (n,s,cr,ar,ir, mr);
	}

	MeanShiftClustering (PointCloud n, double bandWidth) {
		initMSC (n, n, bandWidth*1e-3, bandWidth, bandWidth/4, bandWidth);
	}
	
	public Cluster<Point_d> getClusters() {
		return this.clusters;
	}

	/**
	 * Single cluster detection -- returns approximate peak and cluster points
	 * The output is a list of point containing:
	 *  - all the points belonging to the detected cluster
	 *  - the peak point (at the top of the list)
	 */
	public PointCloud detectCluster (Point_d seed, int clusterIndex) {
		//COMPLETE
		throw new Error("To be completed: ex 2");
	}


	/**
	 * Perform cluster merging
	 * Remark: cluster center is at top of cluster cloud
	 * @param cluster the point cloud to be merge (cluster), containing at the top its center
	 * @param clusterCenters[] the set (array) of cluster centers
	 * @return -1 if no merge is performed, 'i' if the input cluster has been associated with the cluster i (already existing)
	 */
	public int mergeCluster (PointCloud cluster, Point_d[] clusterCenters) {
		//COMPLETE
		throw new Error("To be completed: ex 2");
	}


	/**
	 * Main algorithm for detecting all clusters
	 * Clusters are detected iteratively (until all points are processed)
	 * Clusters are merged if required: when the corresponding peaks are close
	 * 
	 * @return Point_d[] an array of points, of size n .First i elements are cluster centers (non null points), remaining n-i elements must be null
	 */
	public Point_d[] computeClusters () {
		//COMPLETE
		throw new Error("To be completed");
	}

}


