import Jcg.geometry.*;

import java.util.*;;

/**
 * A class implementing a Kd-tree data structure
 * 
 * @author Luca Castelli Aleardi and Steve Oudot (Ecole Polytechnique, INF562)
 * @version jan 2014
 */
public class KdTree<X extends Point_> {

	//cutDimension : 0,1,2 pour x,y,z.
	private int pointDimension; // dimension of the input points
	private int cutDimension; // direction of the cut
	private double cutValue; // cut location
	private int numPoints; // number of points in a node of the tree
	private PointCloud points; // points associated to a node of the tree
	private KdTree<X> lowerHalf, upperHalf; // descendant trees

	/**
	 * Split a point cloud into two sub-point clouds (lower an upper point clouds)
	 */    
	//-- MODIFS au cas o� n.p.Cartesian(cutDim) == cutValue
	public static PointCloud[] split(PointCloud N, double cutValue, int cutDim) {
		PointCloud[] subN=new PointCloud[2]; 
		subN[0] = null; subN[1] = null;
		int sizes[] = new int[2]; //initilis�es � 0 par Java
		int choixListe = 0;
		for (PointCloud n = N; n != null; n = n.next) {
			//Si n.p.Cartesian(cutDim) == cutValue, on met le point dans la plus petite liste
			//Sinon on compare juste n.p.Cartesian(cutDim) � cutValue
			if ((n.p.getCartesian(cutDim).doubleValue() < cutValue) || (n.p.getCartesian(cutDim).doubleValue() == cutValue && sizes[0] < sizes[1]))
				choixListe = 0;
			else choixListe = 1;
			subN[choixListe] = new PointCloud (n.p, subN[choixListe], false);
			sizes[choixListe]++;
		}
		return subN;
	}

	/**
	 * Construct a Kd-Tree from a point cloud (in dimension pDim)
	 */    
	public static<X extends Point_> KdTree<X> constructDataStructure(PointCloud N, int pDim) {
		return new KdTree<X>(N, pDim, 0);
	}

	/**
	 * Constructor -- builds the entire Kd-tree at once recursively
	 */    
	public KdTree (PointCloud N, int pDim, int cutDim) {
		//COMPLETE
		//On initialise les donn�es associ�es au noeud du KdTree qu'on est en train de cr�er
		this.pointDimension = pDim;
		this.cutDimension = cutDim;
		this.points = N;
		this.numPoints = PointCloud.size(N);
		
		throw new Error("To be completed: ex 1");
	} 

	/**
	 * Range search: return the list of nearest point to a given query point q.
	 * The output is the set of points at distance at most sqRad from q.
	 */    
	public PointCloud OrthogonalRangeSearch(X q, double sqRad) {
		//COMPLETE
		throw new Error("To be completed: ex 1");
	}

	//-----------------------------------
	//--- Auxiliary methods on trees ----
	//-----------------------------------

	public static<X extends Point_> int size(KdTree<X> t) {
		int result=0;
		if(t==null) return 0;
		else {
			result=size(t.lowerHalf);
			result=result+size(t.upperHalf);
		}
		return result+1;
	}

	public static<X extends Point_> boolean checkBalance(KdTree<X> t) {
		if (t.lowerHalf==null && t.upperHalf==null)
			return true;
		if (t.numPoints < 200) 
			return true;
		boolean result=true;
		if ((double)t.lowerHalf.numPoints/(double)t.numPoints < 0.25) {
			System.out.println("Bad balance in kd-tree! (" + 
					t.lowerHalf.numPoints + "/" + t.numPoints +
					"=" + (double)t.lowerHalf.numPoints/(double)t.numPoints + ")");
			result=false;
		}
		if ((double)t.lowerHalf.numPoints/(double)t.numPoints > 0.75) {
			System.out.println("Bad balance in kd-tree! (" + 
					t.lowerHalf.numPoints + "/" + t.numPoints +
					"=" + (double)t.lowerHalf.numPoints/(double)t.numPoints + ")");
			result=false;
		}
		result=result && checkBalance(t.lowerHalf);
		result=result && checkBalance(t.upperHalf);

		return result;
	}

	public static<X extends Point_> int leavesNumber(KdTree<X> t) {
		int result=0;
		if(t==null) return 0;
		if(t.upperHalf==null && t.lowerHalf==null)
			return 1;
		else {
			result=leavesNumber(t.lowerHalf);
			result=result+leavesNumber(t.upperHalf);
		}
		return result;
	}

	public static<X extends Point_> String toString(KdTree<X> t) {
		String result="";
		if(t==null) return result;
		if(t.upperHalf==null && t.lowerHalf==null)
			return ""+t.points+"\n";
		else {
			result=toString(t.lowerHalf);
			result=result+toString(t.upperHalf);
		}
		return result;
	}

	public static<X extends Point_> ArrayList<Point_d> toList(KdTree<X> t, ArrayList<Point_d> list) {
		if(t==null) return list;
		if(t.upperHalf==null && t.lowerHalf==null)
			list.add(t.points.p);
		else {
			toList(t.lowerHalf, list);
			toList(t.upperHalf, list);
		}
		return list;
	}

}
