import java.util.Calendar;

import Jcg.geometry.Point_;

/**
 * Class providing fast range search (using Kd-trees)
 * 
 * @author Luca Castelli Aleardi and Steve Oudot (Ecole Polytechnique, INF562)
 * @version jan 2014
 */
public class FastRangeSearch <X extends Point_> implements RangeSearch<X> {

	private KdTree<X> kdTree; // Kd-tree data structure storing the point cloud

	static long queryTime=0;
	static long constructionTime=0;
	static long basicQueryTime=0;    

	public static void timePerformance() {
		System.out.println("Range Search performaces:\nTotal construction time: " + constructionTime/1000 + "s " + 
				constructionTime%1000 + "ms");   	
		System.out.println("Total NN query time: " + queryTime/1000 + "s " + 
				queryTime%1000 + "ms\n");   	
	}

	/**
	 * Construct the data structure for range search
	 * 
	 * @param PointCloud the input points
	 */
	public FastRangeSearch (PointCloud N) {
		if (N == null)
			kdTree = null;
		else {
			Calendar rightNow = Calendar.getInstance();
			long time0 = rightNow.getTimeInMillis();

			kdTree=KdTree.constructDataStructure(N, N.p.dimension());

			rightNow = Calendar.getInstance();
			constructionTime = constructionTime+(rightNow.getTimeInMillis()-time0);
		}
	}


	/**
	 * Main search procedure (for Range search queries)
	 */
	public PointCloud NN (X q, double sqRad) {
		Calendar rightNow = Calendar.getInstance(); // to compute query time
		long time0 = rightNow.getTimeInMillis();

		PointCloud result;
		//choose your favorite Nearest neighbor search method
		//result=basicNN (q, N, sqRad);
		result=this.OrthogonalRangeSearch (q, sqRad); // efficient NN search

		rightNow = Calendar.getInstance(); // to compute query time
		queryTime = queryTime+(rightNow.getTimeInMillis()-time0);

		return result;
	}

	/**
	 * Perform range search using KdTrees
	 * 
	 * @param q the query point
	 * @param sqRad the (squared) radius of the Euclidean ball
	 * @return PointCloud the points in the range (epsilon close to q)
	 */
	public PointCloud OrthogonalRangeSearch(X q, double sqRad) {
		if (kdTree == null)
			return null;
		else {
			PointCloud result;
			result=kdTree.OrthogonalRangeSearch (q, sqRad);
			return result;
		}
	}
	
}


