
/**
 * l'état donne la position de chaque voiture, avec la convention suivante :
 * pour une voiture horizontale c'est la colonne de sa case la plus à gauche
 * pour une voiture verticale c'est la colonne de sa case la plus haute
 * (rappel : la colonne la plus à gauche est 0, la ligne la plus haute est 0)
 */

class State {
	RushHour plateau;
	int[] pos;

	/** on se rappelle quel déplacement a conduit à cet état, pour l'affichage de la solution */
	State prev;
	int c;
	int d;

	/** construit un état initial (c, d et prev ne sont pas significatifs) */
	public State(RushHour plateau, int[] pos) {
		// throw new Error("Constructeur State(RushHour plateau, int[] pos) à compléter (Question 1.1)");
		this.plateau = plateau;
		this.pos = new int[pos.length];
		for (int i = 0; i < pos.length; i++)
			this.pos[i] = pos[i];
		this.prev = null;
	}

	/** construit un état obtenu à partir de s en déplaçant la voiture c de d (-1 ou +1) */
	public State(State s, int c, int d) {
		this.plateau = s.plateau;
		this.pos = new int[s.pos.length];
		for(int i = 0; i < this.pos.length; i++) {
			this.pos[i] = s.pos[i];
		}
		this.pos[c] += d;
		this.prev = s;
		this.c = c;
		this.d = d;
	}

	/** a-t-on gagné ? */
	public boolean success() {
		return this.pos[0] == 4;
    }
	
	/** quelles sont les places libres */
	public boolean[][] free() {
		boolean[][] free = new boolean[6][6];
		for(int i = 0; i < 6; i++) {
			for(int j = 0; j < 6; j++) {
				free[i][j] = true;
			}
		}
		for(int c = 0; c < this.plateau.nbCars; c++) {
			for(int l = 0; l < this.plateau.len[c]; l++) {
				if(this.plateau.horiz[c]) {
					free[this.plateau.moveOn[c]][this.pos[c] + l] = false;	
				} else {
					free[this.pos[c] + l][this.plateau.moveOn[c]] = false;	
				}
			}
		}
		return free;
	}

	/* test d'égalité */
	public boolean equals(Object o) {
		State s = (State)o;
		if (s.pos.length != pos.length)
			throw new Error("State.equals: not the same lengths");
		for (int i = 0; i < pos.length; i++)
			if (pos[i] != s.pos[i]) return false;
		return true;
	}

	/** code de hachage */
	public int hashCode() {
		int h = 0;
		for (int i = 0; i < pos.length; i++)
			h = 37 * h + pos[i];
		return h;
	}


}

