import java.util.LinkedList;
import java.util.HashSet;




/**
 * la représentation du problème est la suivante :
 * la grille a 6 colonnes, numérotées 0 à 5 de gauche à droite
 * et 6 lignes, numérotées 0 à 5 de haut en bas
 *
 * il y a nbCars voitures, numérotées de 0 à nbCars-1
 * pour chaque voiture i :
 * - color[i] donne sa couleur
 * - horiz[i] indique s'il s'agit d'une voiture horizontale
 * - len[i] donne sa longueur (2 ou 3)
 * - moveOn[i] indique sur quelle ligne elle se déplace pour une voiture horizontale
 *   et sur quelle colonne pour une voiture verticale
 *
 * la voiture d'indice 0 est celle qui doit sortir, on a donc
 * horiz[0]==true, len[0]==2, moveOn[0]==2
 */
class RushHour {
	int nbCars;
	String[] color;
	boolean[] horiz;
	int[] len;
	int[] moveOn;

    public RushHour(int nbCars,String[] color,boolean[] horiz,int[] len,int[] moveOn){
        this.nbCars = nbCars;
        this.color = color;
        this.horiz = horiz;
        this.len = len;
        this.moveOn = moveOn;
    }
    
	/** renvoie la liste des déplacements possibles à partir de s */
	LinkedList<State> moves(State s) {
		boolean[][] free = s.free();
		LinkedList<State> l = new LinkedList<State>();
		for(int c = 0; c < nbCars; c++) {
			if(horiz[c] && s.pos[c] > 0 && free[moveOn[c]][s.pos[c] - 1]) l.push(new State(s, c, -1)); // deplacement à gauche
			if(horiz[c] && s.pos[c] + len[c] < 6 && free[moveOn[c]][s.pos[c] + len[c]]) l.push(new State(s, c, 1)); // déplacement à droite
			if(!horiz[c] && s.pos[c] > 0 && free[s.pos[c] - 1][moveOn[c]]) l.push(new State(s, c, -1)); // déplacement en haut
			if(!horiz[c] && s.pos[c] + len[c] < 6 && free[s.pos[c] + len[c]][moveOn[c]]) l.push(new State(s, c, 1)); // déplacement en bas
		}
		return l;
	}



	State solveDFS(State s){
			/** cherche une solution à partir de l'état s */
		HashSet<State> visited = new HashSet<State>();
		visited.add(s);
		LinkedList<State> stack = new LinkedList<State>();
		stack.addFirst(s);
		while (!stack.isEmpty()) {
			State currentState = stack.poll();
			if(currentState.success()) return currentState;
			for(State nextState: moves(currentState)) {
				if(!visited.contains(nextState)) {
					visited.add(nextState);
					stack.addFirst(nextState);
				}
			}
		}
		throw new Error("pas de solution");
	}


	/** cherche une solution à partir de l'état s */
	State solveBFS(State s) {
			/** cherche une solution à partir de l'état s */
			HashSet<State> visited = new HashSet<State>();
			visited.add(s);
			LinkedList<State> queue = new LinkedList<State>();
			queue.add(s);
			while (!queue.isEmpty()) {
				State currentState = queue.poll();
				if(currentState.success()) return currentState;
				for(State nextState: moves(currentState)) {
					if(!visited.contains(nextState)) {
						visited.add(nextState);
						queue.add(nextState);
					}
				}
			}
			throw new Error("pas de solution");
	}

	/** affiche une solution */
	static int nbMoves = 0;
	void printSolution(State s) {
		if (s.prev != null) {
			nbMoves++;
			printSolution(s.prev);
			System.out.print("on déplace le véhicule " + color[s.c] + " ");
			if (horiz[s.c])
				System.out.println(s.d > 0 ? "vers la droite" : "vers la gauche");
			else
				System.out.println(s.d > 0 ? "vers le bas" : "vers le haut");
		} else {
			System.out.println(nbMoves + " déplacements");
			nbMoves = 0;
		}
    }

	
	
	
	
}