import java.util.LinkedList;

public class Row { // représente une ligne de fruits
    private final int[] fruits;

    // constructeur d'une ligne vide
    Row() {
        this.fruits = new int[0];
    }

    // constructeur à partir du champ fruits
    Row(int[] fruits) {
        this.fruits = fruits;
    }

    @Override
    public boolean equals(Object o) {
        // equals prend en argument un objet quelconque o
        // ici on suppose que o est de la classe Row et on le convertit
        Row that = (Row) o;
        if (this.fruits.length != that.fruits.length)
            return false;
        for (int i = 0; i < this.fruits.length; ++i) {
            if (this.fruits[i] != that.fruits[i])
                return false;
        }
        // si on arrive ici, les deux lignes sont de même longueur et les
        // fruits à la même position coïncident : on a donc égalité
        return true;
    }

    // haché de la ligne
    @Override
    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < fruits.length; ++i) {
            hash = 2 * hash + fruits[i];
        }
        return hash;
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < fruits.length; ++i)
            s.append(fruits[i]);
        return s.toString();
    }

    // renvoie une nouvelle ligne en ajoutant fruit à la fin de la ligne
    Row extendedWith(int fruit) {
        int[] newFruits = new int[fruits.length + 1];
        for (int i = 0; i < fruits.length; ++i)
            newFruits[i] = fruits[i];
        newFruits[fruits.length] = fruit;
        return new Row(newFruits);
    }

    // renvoie la liste de toutes les lignes stables de largeur width
    static LinkedList<Row> allStableRows(int width) {
        LinkedList<Row> res = new LinkedList<Row>();
        if (width == 0) {
            res.add(new Row());
        } else {
            // on parcourt toutes les lignes stables de largueur width-1
            for (Row r : allStableRows(width - 1)) {
                // on essaie d'ajouter 0 ou 1 à chaque ligne r
                for (int fruit = 0; fruit < 2; fruit++) {
                    // si la ligne était de longueur < 2 ou qu'au moins un
                    // de ses deux derniers fruits est distinct de fruit
                    // on peut ajouter fruit et préserver la stabilite
                    int l = r.fruits.length;
                    if (l < 2 || r.fruits[l - 2] != fruit || r.fruits[l - 1] != fruit)
                        res.add(r.extendedWith(fruit));
                }
            }
        }
        return res;
    }

    // vérifie si la ligne peut s'empiler avec les lignes r1 et r2
    // sans avoir trois fruits du même type adjacents
    boolean areStackable(Row r1, Row r2) {
        if (this.fruits.length != r1.fruits.length || this.fruits.length != r2.fruits.length)
            return false;
        for (int i = 0; i < this.fruits.length; ++i) {
            if (this.fruits[i] == r1.fruits[i] && this.fruits[i] == r2.fruits[i])
                return false;
        }
        return true;
    }
}
