import java.util.ArrayList;
import java.util.LinkedList;

public class HashTable { // table de hachage
	static final int M = 50000;
	ArrayList<LinkedList<Quadruple>> buckets;

	HashTable() {
		buckets = new ArrayList<LinkedList<Quadruple>>(M);
		for (int i = 0; i < M; i++) {
			buckets.add(new LinkedList<Quadruple>());
		}
	}

	// renvoie le code de hachage du triplet (r1, r2, height)
	static int hashCode(Row r1, Row r2, int height) {
        return r1.hashCode() * 2147483647 + r2.hashCode() * 1073741789 + height;
	}

	// renvoie le seau du triplet (r1, r2, height)
	static int bucket(Row r1, Row r2, int height) {
		int mod = hashCode(r1, r2, height) % M;
		return (mod >= 0 ? mod : mod + M);
	}

	// ajoute le quadruplet (r1, r2, height, result) dans le seau indiqué par la
	// methode bucket
	void add(Row r1, Row r2, int height, long result) {
		buckets.get(bucket(r1, r2, height)).add(new Quadruple(r1, r2, height, result));
	}

	// recherche dans la table une entrée pour le triplet (r1, r2, height)
	Long find(Row r1, Row r2, int height) {
		for (Quadruple q : buckets.get(bucket(r1, r2, height))) {
			if (r1.equals(q.r1) && r2.equals(q.r2) && height == q.height)
				return Long.valueOf(q.result);
		}	
		return null;
	}

}