import java.util.LinkedList;

public class CountConfigurationsNaive { // comptage des configurations stables

    // renvoie le nombre de grilles dont les premières lignes sont r1 et r2,
    // dont les lignes sont des lignes de rows et dont la hauteur est height
    static long count(Row r1, Row r2, LinkedList<Row> rows, int height) {
        if (height <= 1)
            return 0; // aucune configuration car on veut au moins r1 et r2
        if (height == 2)
            return 1; // une seule configuration (r1,r2)
        long res = 0;
        for (Row r3 : rows) {
            if (r3.areStackable(r1, r2))
                res += count(r2, r3, rows, height - 1);
        }
        return res;

    }

    // renvoie le nombre de grilles à n lignes et n colonnes
    static long count(int n) {
        LinkedList<Row> rows = Row.allStableRows(n);
        // n <= 1
        if (n <= 1)
            return rows.size();
        // n > 1
        long res = 0;
        // on parcourt toutes les paires (r1,r2) ...
        for (Row r1 : rows)
            for (Row r2 : rows)
                // ... et on ajoute le nombre de grilles qui commencent par (r1,r2)
                res += count(r1, r2, rows, n);
        return res;
    }
}