import java.util.LinkedList;

public class CountConfigurationsHashTable {
    static HashTable memo = new HashTable();

    // renvoie le nombre de grilles dont les premières lignes sont r1 et r2,
    // dont les lignes sont des lignes de rows et dont la hauteur est height
    // en utilisant notre table de hachage
    static long count(Row r1, Row r2, LinkedList<Row> rows, int height) {
        if (height <= 1)
            return 0; // aucune configuration car on veut au moins r1 et r2
        if (height == 2)
            return 1; // une seule configuration (r1,r2)
        // on teste si on a deja fait ce calcul ...
        Long res = memo.find(r1, r2, height);
        if (res != null)
            return res;
        // ... sinon on le fait ...
        res = 0L;
        for (Row r3 : rows) {
            if (r3.areStackable(r1, r2))
                res += count(r2, r3, rows, height - 1);
        }
        // ... et on mémorise le résultat
        memo.add(r1, r2, height, res);
        return res;
    }

    // renvoie le nombre de grilles a n lignes et n colonnes
    static long count(int n) {
        LinkedList<Row> rows = Row.allStableRows(n);
        // n <= 1
        if (n <= 1)
            return rows.size();
        // n > 1
        long res = 0;
        // on parcourt toutes les paires (r1,r2) ...
        for (Row r1 : rows)
            // on pourrait ne considérer que les lignes r2 qui viennent après r1 dans la
            // liste, mais ça ne changerait pas grand-chose vu qu'on a mémoïsé
            for (Row r2 : rows)
                // ... et on ajoute le nombre de grilles qui commencent par (r1,r2)
                res += count(r1, r2, rows, n);
        return res;

    }
}