import java.util.HashMap;
import java.util.LinkedList;

public class CountConfigurationsHashMap {
    static HashMap<Triple, Long> memo = new HashMap<Triple, Long>();

    // renvoie le nombre de grilles dont les premières lignes sont r1 et r2,
    // dont les lignes sont des lignes de rows et dont la hauteur est height
    // en utilisant la HashMap de java
    static long count(Row r1, Row r2, LinkedList<Row> rows, int height) {
        if (height <= 1)
            return 0; // aucune configuration car on veut au moins r1 et r2
        if (height == 2)
            return 1; // une seule configuration (r1,r2)
        Triple t = new Triple(r1, r2, height);
        Long res = memo.get(t);
        if (res != null)
            return res;
        res = 0L;
        for (Row r3 : rows) {
            if (r3.areStackable(r1, r2))
                res += count(r2, r3, rows, height - 1);
        }
        memo.put(t, res);
        return res;
    }

    // renvoie le nombre de grilles à n lignes et n colonnes
    static long count(int n) {
        LinkedList<Row> rows = Row.allStableRows(n);
        // n <= 1
        if (n <= 1)
            return rows.size();
        // n > 1
        long res = 0;
        // on parcourt toutes les paires (r1,r2) ...
        for (Row r1 : rows)
            for (Row r2 : rows)
                // ... et on ajoute le nombre de grilles qui commencent par (r1,r2)
                res += count(r1, r2, rows, n);
        return res;
    }
}