import java.util.LinkedList;

class Deck { // représente un paquet de cartes

	LinkedList<Integer> cards;

  @Override
	public int hashCode() {
		return 0;
	}
	
	@Override
	public boolean equals(Object o) {
		Deck d = (Deck) o;
		return cards.equals(d.cards);
	}

	// constructeur d'un paquet vide
	Deck() {
		cards = new LinkedList<Integer>();
	}

	// constructeur à partir du champ
	Deck(LinkedList<Integer> cards) {
		this.cards = cards;
	}

	// constructeur d'un paquet de cartes complet trié avec nbVals valeurs
	Deck(int nbVals) {
		cards = new LinkedList<Integer>();
		for (int j = 1; j <= nbVals; j++)
			for (int i = 0; i < 4; i++)
				cards.add(j);
	}

	// copie le paquet de cartes
	Deck copy() {
		Deck d = new Deck();
		for (Integer card : cards)
			d.cards.addLast(card);
		return d;
	}

	// chaîne de caractères représentant le paquet
	@Override
	public String toString() {
		return cards.toString();
	}

	// Question 1

	// prend une carte du paquet d pour la mettre à la fin du paquet courant
	int pick(Deck d) {
		// throw new Error("Méthode pick(Deck d) à compléter (Question 1)");
		if (!d.cards.isEmpty()) {
			int x = d.cards.removeFirst();
			cards.addLast(x);
			return x;
		} else {
			return -1;
		}
	}

	// prend toutes les cartes du paquet d pour les mettre à la fin du paquet courant
	void pickAll(Deck d) {
		// throw new Error("Méthode pickAll(Deck d) à compléter (Question 1)");
		while (!d.cards.isEmpty())
			pick(d);
	}

	// vérifie si le paquet courant est valide
	boolean isValid(int nbVals) {
		// throw new Error("Méthode isValid(int nbVals) à compléter (Question 1)");
		int[] numbers = new int[nbVals];
		for (Integer x : cards) {
			if (x < 1 || x > nbVals || numbers[x - 1] > 3)
				return false;
			numbers[x - 1]++;
		}
		return true;
	}

	// Question 2.1

	// choisit une position pour la coupe
	int cut() {
		// throw new Error("Méthode cut() à compléter (Question 2.1)");
		int cut = 0;
		for (int i = 0; i < cards.size(); i++) {
			cut += (Math.random() < .5 ? 1 : 0);
		}
		return cut;
	}

	// coupe le paquet courant en deux au niveau de la position donnée par cut()
	Deck split() {
		// throw new Error("Méthode split() à compléter (Question 2.1)");
		int c = cut();
		Deck res = new Deck();
		for (int i = 0; i < c; i++)
			res.pick(this);
		return res;
	}

	// Question 2.2

	// mélange le paquet courant et le paquet d
	void riffleWith(Deck d) {
		// throw new Error("Méthode riffleWith(Deck d) à compléter (Question 2.2)");
		Deck f = new Deck();
		while (!this.cards.isEmpty() || !d.cards.isEmpty()) {
			int a = this.cards.size();
			int b = d.cards.size();
			if (Math.random() * (a + b) < a)
				f.pick(this);
			else
				f.pick(d);
		}
		this.cards = f.cards;
	}

	// Question 2.3

	// mélange le paquet courant au moyen du riffle shuffle
	void riffleShuffle(int m) {
		// throw new Error("Méthode riffleShuffle(int m) à compléter (Question 2.3)");
		for (int i = 0; i < m; i++) {
			riffleWith(split());
		}	
	}
}
